/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class ASN1Header {
    private byte[] cachedEncoding = null;
    private Tag tag;
    private long contentLength;
    public static final Form PRIMITIVE = Form.PRIMITIVE;
    public static final Form CONSTRUCTED = Form.CONSTRUCTED;
    private Form form;
    private static final int MAX_LOOK_AHEAD = 32;

    public long getTotalLength() {
        if (this.contentLength == -1L) {
            return -1L;
        }
        return (long)this.encode().length + this.contentLength;
    }

    public Tag getTag() {
        return this.tag;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public Form getForm() {
        return this.form;
    }

    public static ASN1Header lookAhead(InputStream derStream) throws IOException, InvalidBERException {
        if (!derStream.markSupported()) {
            throw new IOException("Mark not supported on this input stream");
        }
        derStream.mark(32);
        ASN1Header info = new ASN1Header(derStream);
        derStream.reset();
        return info;
    }

    public ASN1Header(InputStream istream) throws InvalidBERException, IOException {
        long tagNum;
        ByteArrayOutputStream encoding = new ByteArrayOutputStream();
        int inInt = istream.read();
        if (inInt == -1) {
            throw new InvalidBERException("End-of-file reached while decoding ASN.1 header");
        }
        encoding.write(inInt);
        byte byte1 = (byte)inInt;
        Tag.Class tagClass = Tag.Class.fromInt((byte1 & 0xFF) >>> 6);
        this.form = (byte1 & 0x20) == 32 ? CONSTRUCTED : PRIMITIVE;
        if ((byte1 & 0x1F) == 31) {
            int a;
            byte next;
            Vector<Byte> bV = new Vector<Byte>();
            do {
                if ((inInt = istream.read()) == -1) {
                    throw new InvalidBERException("End-of-file reached while decoding ASN.1 header");
                }
                encoding.write(inInt);
                next = (byte)inInt;
                bV.addElement(new Byte(next));
            } while ((next & 0x80) == 128);
            Assert._assert(bV.size() > 0);
            byte[] bA = new byte[(bV.size() * 7 + 7) / 8];
            for (a = 0; a < bA.length; ++a) {
                bA[a] = 0;
            }
            int shift = 0;
            a = bA.length - 1;
            for (int v = bV.size() - 1; v >= 0; --v) {
                Assert._assert(v >= 0);
                Assert._assert(v < bV.size());
                Assert._assert(a >= 0);
                Assert._assert(a < bA.length);
                byte b = (byte)((Byte)bV.elementAt(v) & 0x7F);
                int n = a;
                bA[n] = (byte)(bA[n] | b << shift);
                if (shift > 1) {
                    Assert._assert(a > 0);
                    int n2 = --a;
                    bA[n2] = (byte)(bA[n2] | b >>> 8 - shift);
                }
                shift = (shift + 7) % 8;
            }
            tagNum = new BigInteger(1, bA).longValue();
        } else {
            tagNum = byte1 & 0x1F;
        }
        this.tag = new Tag(tagClass, tagNum);
        inInt = istream.read();
        if (inInt == -1) {
            throw new InvalidBERException("End-of-file reached while decoding ASN.1 header");
        }
        encoding.write(inInt);
        byte lenByte = (byte)inInt;
        if ((lenByte & 0x80) == 0) {
            this.contentLength = lenByte;
        } else if ((lenByte & 0x7F) == 0) {
            this.contentLength = -1L;
        } else {
            byte[] lenBytes = new byte[lenByte & 0x7F];
            ASN1Util.readFully(lenBytes, istream);
            encoding.write(lenBytes);
            this.contentLength = new BigInteger(1, lenBytes).longValue();
        }
        this.cachedEncoding = encoding.toByteArray();
    }

    public ASN1Header(Tag tag, Form form, long contentLength) {
        this.tag = tag;
        this.form = form;
        Assert._assert(contentLength >= 0L);
        this.contentLength = contentLength;
    }

    public void encode(OutputStream ostream) throws IOException {
        ostream.write(this.encode());
    }

    public byte[] encode() {
        if (this.cachedEncoding != null) {
            return this.cachedEncoding;
        }
        ByteArrayOutputStream cache = new ByteArrayOutputStream();
        int idOctet = 0;
        idOctet = (byte)(idOctet | this.tag.getTagClass().toInt() << 6);
        if (this.form == CONSTRUCTED) {
            idOctet = (byte)(idOctet | 0x20);
        }
        if (this.tag.getNum() <= 30L) {
            idOctet = (byte)((long)idOctet | this.tag.getNum() & 0x1FL);
            cache.write(idOctet);
        } else {
            idOctet = (byte)(idOctet | 0x1F);
            BigInteger tagNum = BigInteger.valueOf(this.tag.getNum());
            cache.write(idOctet);
            int bitlength = tagNum.bitLength();
            int reps = (bitlength + 6) / 7;
            --reps;
            while (reps > 0) {
                long shifted = this.tag.getNum() >>> 7 * reps;
                cache.write((byte)shifted & 0x7F | 0x80);
                --reps;
            }
            cache.write((byte)this.tag.getNum() & 0x7F);
        }
        if (this.contentLength == -1L) {
            cache.write(-128);
        } else if (this.contentLength <= 127L) {
            cache.write((byte)this.contentLength);
        } else {
            byte[] val = ASN1Header.unsignedBigIntToByteArray(BigInteger.valueOf(this.contentLength));
            cache.write((byte)val.length | 0x80);
            cache.write(val, 0, val.length);
        }
        this.cachedEncoding = cache.toByteArray();
        return this.cachedEncoding;
    }

    public static byte[] unsignedBigIntToByteArray(BigInteger bi) {
        Assert._assert(bi.compareTo(BigInteger.valueOf(0L)) != -1);
        int bitlen = bi.bitLength();
        int bytelen = bitlen == 0 ? 1 : (bitlen + 7) / 8;
        byte[] withSign = bi.toByteArray();
        if (bytelen == withSign.length) {
            return withSign;
        }
        Assert._assert(bytelen == withSign.length - 1);
        Assert._assert(withSign[0] == 0);
        byte[] without = new byte[bytelen];
        System.arraycopy(withSign, 1, without, 0, bytelen);
        return without;
    }

    public void validate(Tag expectedTag, Form expectedForm) throws InvalidBERException {
        this.validate(expectedTag);
        if (this.getForm() != expectedForm) {
            throw new InvalidBERException("Incorrect form: expected [" + expectedForm + "], found [" + this.getForm());
        }
    }

    public void validate(Tag expectedTag) throws InvalidBERException {
        if (!this.getTag().equals(expectedTag)) {
            throw new InvalidBERException("Incorrect tag: expected [" + expectedTag + "], found [" + this.getTag() + "]");
        }
    }

    public boolean isEOC() {
        return this.tag.equals(Tag.EOC);
    }
}

