/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class ASN1Util {
    public static byte[] encode(ASN1Value val) {
        return ASN1Util.encode(val.getTag(), val);
    }

    public static byte[] encode(Tag implicitTag, ASN1Value val) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            val.encode(implicitTag, bos);
            return bos.toByteArray();
        }
        catch (IOException e) {
            Assert.notReached("Encoding to byte array gave IOException");
            return null;
        }
    }

    public static ASN1Value decode(ASN1Template template, byte[] encoded) throws InvalidBERException {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(encoded);
            return template.decode(bis);
        }
        catch (IOException e) {
            Assert.notReached("Decoding from byte array gave IOException");
            return null;
        }
    }

    public static ASN1Value decode(Tag implicitTag, ASN1Template template, byte[] encoded) throws InvalidBERException {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(encoded);
            return template.decode(implicitTag, bis);
        }
        catch (IOException e) {
            Assert.notReached("Decoding from byte array gave IOException");
            return null;
        }
    }

    public static void readFully(byte[] bytes, InputStream istream) throws IOException {
        int nr;
        for (int numRead = 0; numRead < bytes.length; numRead += nr) {
            nr = istream.read(bytes, numRead, bytes.length - numRead);
            if (nr != -1) continue;
            throw new EOFException();
        }
    }
}

