/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class BIT_STRING
implements ASN1Value {
    private byte[] bits;
    private int padCount;
    public static final Tag TAG = new Tag(Tag.UNIVERSAL, 3L);
    public static final Form FORM = Form.PRIMITIVE;
    private static final Template templateInstance = new Template();

    private BIT_STRING() {
    }

    public BIT_STRING(byte[] bits, int padCount) throws NumberFormatException {
        if (padCount < 0 || padCount > 7) {
            throw new NumberFormatException();
        }
        if (bits.length == 0 && padCount != 0) {
            throw new NumberFormatException();
        }
        this.bits = bits;
        this.padCount = padCount;
    }

    public BIT_STRING(BitSet bs, int numBits) throws NumberFormatException {
        if (numBits < 0 || numBits > bs.size()) {
            throw new NumberFormatException();
        }
        this.bits = new byte[(numBits + 7) / 8];
        this.padCount = 8 * this.bits.length - numBits;
        Assert._assert(this.padCount >= 0);
        for (int i = 0; i < numBits; ++i) {
            if (!bs.get(i)) continue;
            int n = i / 8;
            this.bits[n] = (byte)(this.bits[n] | 128 >>> i % 8);
        }
    }

    public byte[] getBits() {
        return this.bits;
    }

    public BitSet toBitSet() {
        BitSet bs = new BitSet();
        int numBits = this.bits.length * 8 - this.padCount;
        for (int i = 0; i < numBits; ++i) {
            if ((this.bits[i / 8] & 128 >>> i % 8) != 0) {
                bs.set(i);
                continue;
            }
            bs.clear(i);
        }
        return bs;
    }

    public boolean[] toBooleanArray() {
        boolean[] array = new boolean[this.bits.length * 8 - this.padCount];
        for (int i = 0; i < array.length; ++i) {
            if ((this.bits[i / 8] & 128 >>> i % 8) == 0) continue;
            array[i] = true;
        }
        return array;
    }

    public int getPadCount() {
        return this.padCount;
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encode(baos);
        return baos.toByteArray();
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        ASN1Header head = new ASN1Header(implicitTag, FORM, this.bits.length + 1);
        head.encode(ostream);
        ostream.write(this.padCount);
        ostream.write(this.bits);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            try {
                ASN1Header head = new ASN1Header(istream);
                head.validate(implicitTag);
                if (head.getContentLength() == -1L) {
                    ASN1Header ahead;
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    int padCount = 0;
                    do {
                        if ((ahead = ASN1Header.lookAhead(istream)).isEOC()) continue;
                        if (padCount != 0) {
                            throw new InvalidBERException("Element of constructed BIT STRING has nonzero unused bits, but is not\nthe last element of the construction.");
                        }
                        Template bst = new Template();
                        BIT_STRING bs = (BIT_STRING)bst.decode(istream);
                        bos.write(bs.getBits());
                        padCount = bs.getPadCount();
                    } while (!ahead.isEOC());
                    ahead = new ASN1Header(istream);
                    return new BIT_STRING(bos.toByteArray(), padCount);
                }
                int padCount = istream.read();
                if (padCount == -1) {
                    throw new InvalidBERException.EOF();
                }
                if (padCount < 0 || padCount > 7) {
                    throw new InvalidBERException("Unused bits not in range [0,7]");
                }
                byte[] bits = new byte[(int)head.getContentLength() - 1];
                ASN1Util.readFully(bits, istream);
                return new BIT_STRING(bits, padCount);
            }
            catch (InvalidBERException e) {
                throw new InvalidBERException(e, "BIT STRING");
            }
        }
    }
}

