/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CharConverter;
import org.mozilla.jss.asn1.CharacterString;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class BMPString
extends CharacterString
implements ASN1Value {
    private static final BMPConverter converterInstance = new BMPConverter();
    static final Tag TAG = new Tag(Tag.UNIVERSAL, 30L);
    static final Form FORM = Form.PRIMITIVE;
    private static final Template templateInstance = new Template();

    public BMPString(char[] chars) throws CharConversionException {
        super(chars);
    }

    public BMPString(String s) throws CharConversionException {
        super(s);
    }

    @Override
    CharConverter getCharConverter() {
        return converterInstance;
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    private static class BMPConverter
    implements CharConverter {
        private BMPConverter() {
        }

        @Override
        public char[] byteToChar(byte[] bytes, int offset, int len) throws CharConversionException {
            try {
                String s = new String(bytes, offset, len, "UnicodeBig");
                return s.toCharArray();
            }
            catch (UnsupportedEncodingException e) {
                String err = "Unable to find UnicodeBig encoding mechanism";
                Assert.notReached(err);
                throw new CharConversionException(err);
            }
        }

        @Override
        public byte[] charToByte(char[] chars, int offset, int len) throws CharConversionException {
            try {
                String s = new String(chars, offset, len);
                return s.getBytes("UnicodeBigUnmarked");
            }
            catch (UnsupportedEncodingException e) {
                String err = "Unable to find UnicodeBigUnmarked encoding mechanism";
                Assert.notReached(err);
                throw new CharConversionException(err);
            }
        }
    }

    public static class Template
    extends CharacterString.Template
    implements ASN1Template {
        @Override
        protected Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        protected CharConverter getCharConverter() {
            return new BMPConverter();
        }

        @Override
        protected CharacterString generateInstance(char[] chars) throws CharConversionException {
            return new BMPString(chars);
        }

        @Override
        protected String typeName() {
            return "BMPString";
        }
    }
}

