/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class CHOICE
implements ASN1Value {
    private Tag tag;
    private ASN1Value val;

    private CHOICE() {
    }

    public CHOICE(Tag implicitTag, ASN1Value val) {
        this.tag = implicitTag;
        this.val = val;
    }

    public CHOICE(ASN1Value val) {
        this.tag = val.getTag();
        this.val = val;
    }

    @Override
    public Tag getTag() {
        return this.tag;
    }

    public ASN1Value getValue() {
        return this.val;
    }

    public static Template getTemplate() {
        return new Template();
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.val.encode(this.tag, ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        Assert._assert(implicitTag.equals(this.tag));
        this.val.encode(this.tag, ostream);
    }

    public static class Template
    implements ASN1Template {
        private Vector templates = new Vector();

        public void addElement(ASN1Template template) {
            this.templates.addElement(new Element(template));
        }

        public void addElement(Tag implicitTag, ASN1Template template) {
            this.templates.addElement(new Element(implicitTag, template));
        }

        public int size() {
            return this.templates.size();
        }

        public ASN1Template elementAt(int index) {
            return ((Element)this.templates.elementAt(index)).getTemplate();
        }

        public Tag implicitTagAt(int index) {
            return ((Element)this.templates.elementAt(index)).getImplicitTag();
        }

        public void removeAllElements() {
            this.templates.removeAllElements();
        }

        public void removeElementAt(int index) {
            this.templates.removeElementAt(index);
        }

        @Override
        public boolean tagMatch(Tag t) {
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                ASN1Template templ;
                Tag impl = this.implicitTagAt(i);
                if (!(impl != null ? impl.equals(t) : (templ = this.elementAt(i)).tagMatch(t))) continue;
                return true;
            }
            return false;
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            ASN1Header head = ASN1Header.lookAhead(istream);
            Tag tag = head.getTag();
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                if (this.implicitTagAt(i) != null) {
                    if (!this.implicitTagAt(i).equals(tag)) continue;
                    ASN1Value val = this.elementAt(i).decode(this.implicitTagAt(i), istream);
                    return new CHOICE(this.implicitTagAt(i), val);
                }
                if (!this.elementAt(i).tagMatch(tag)) continue;
                return new CHOICE(this.elementAt(i).decode(istream));
            }
            throw new InvalidBERException("Unable to decode CHOICE");
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            return this.decode(istream);
        }

        private static class Element {
            private ASN1Template template;
            private Tag implicitTag = null;

            public Element(ASN1Template template) {
                this.template = template;
            }

            public Element(Tag implicitTag, ASN1Template template) {
                this.template = template;
                this.implicitTag = implicitTag;
            }

            public ASN1Template getTemplate() {
                return this.template;
            }

            public Tag getImplicitTag() {
                return this.implicitTag;
            }
        }
    }
}

