/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class EXPLICIT
implements ASN1Value {
    public static final Form FORM = Form.CONSTRUCTED;
    private ASN1Value content;
    private Tag tag;

    private EXPLICIT() {
    }

    public EXPLICIT(Tag tag, ASN1Value content) {
        Assert._assert(tag != null && content != null);
        this.content = content;
        this.tag = tag;
    }

    public ASN1Value getContent() {
        return this.content;
    }

    @Override
    public Tag getTag() {
        return this.tag;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.tag, ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.content.encode(bos);
        byte[] contentBytes = bos.toByteArray();
        ASN1Header head = new ASN1Header(implicitTag, FORM, contentBytes.length);
        head.encode(ostream);
        ostream.write(contentBytes);
    }

    public static Template getTemplate(Tag tag, ASN1Template content) {
        return new Template(tag, content);
    }

    public static class Template
    implements ASN1Template {
        private ASN1Template content;
        private Tag tag;

        private Template() {
        }

        public Template(Tag tag, ASN1Template content) {
            this.content = content;
            this.tag = tag;
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return this.tag.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(this.tag, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            try {
                ASN1Header head = new ASN1Header(istream);
                head.validate(implicitTag, Form.CONSTRUCTED);
                ASN1Value val = this.content.decode(istream);
                EXPLICIT e = new EXPLICIT(this.tag, val);
                if (head.getContentLength() == -1L && !(head = new ASN1Header(istream)).isEOC()) {
                    throw new InvalidBERException("No end-of-contents marker");
                }
                return e;
            }
            catch (InvalidBERException e) {
                throw new InvalidBERException(e, "EXPLICIT");
            }
        }
    }
}

