/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;

public class NULL
implements ASN1Value {
    public static final Tag TAG = new Tag(Tag.Class.UNIVERSAL, 5L);
    public static final Form FORM = Form.PRIMITIVE;
    private static final NULL instance = new NULL();
    private static final Template templateInstance = new Template();

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public byte[] getEncoded() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encode(baos);
        return baos.toByteArray();
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        ASN1Header head = new ASN1Header(implicitTag, FORM, 0L);
        head.encode(ostream);
    }

    public static NULL getInstance() {
        return instance;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        public Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            try {
                ASN1Header head = new ASN1Header(istream);
                head.validate(implicitTag, FORM);
                if (head.getContentLength() != 0L) {
                    throw new InvalidBERException("Invalid length (" + head.getContentLength() + ") for NULL; only 0 is permitted");
                }
                return new NULL();
            }
            catch (InvalidBERException e) {
                throw new InvalidBERException(e, "NULL");
            }
        }
    }
}

