/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;

public class OCTET_STRING
implements ASN1Value {
    public static final Tag TAG = new Tag(Tag.Class.UNIVERSAL, 4L);
    public static final Form FORM = Form.PRIMITIVE;
    byte[] data;
    private static final Template templateInstance = new Template();

    @Override
    public Tag getTag() {
        return TAG;
    }

    private OCTET_STRING() {
    }

    public OCTET_STRING(byte[] data) {
        this.data = data;
    }

    public byte[] toByteArray() {
        return this.data;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public byte[] getEncoded() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encode(baos);
        return baos.toByteArray();
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        ASN1Header head = new ASN1Header(implicitTag, FORM, this.data.length);
        head.encode(ostream);
        ostream.write(this.data);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        public Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), istream);
        }

        protected ASN1Value generateInstance(byte[] bytes) {
            return new OCTET_STRING(bytes);
        }

        protected String getName() {
            return "OCTET_STRING";
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            try {
                byte[] data;
                ASN1Header head = new ASN1Header(istream);
                head.validate(implicitTag);
                if (head.getContentLength() == -1L) {
                    ASN1Header ahead;
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    do {
                        if ((ahead = ASN1Header.lookAhead(istream)).isEOC()) continue;
                        Template ot = new Template();
                        OCTET_STRING os = (OCTET_STRING)ot.decode(istream);
                        bos.write(os.toByteArray());
                    } while (!ahead.isEOC());
                    ahead = new ASN1Header(istream);
                    data = bos.toByteArray();
                } else {
                    data = new byte[(int)head.getContentLength()];
                    ASN1Util.readFully(data, istream);
                }
                return this.generateInstance(data);
            }
            catch (InvalidBERException e) {
                throw new InvalidBERException(e, this.getName());
            }
        }
    }
}

