/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.PrintableString;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public abstract class TimeBase
implements ASN1Value {
    public static final Form FORM = Form.PRIMITIVE;
    private Date date;

    @Override
    public abstract Tag getTag();

    public Date toDate() {
        return this.date;
    }

    protected abstract boolean isUTC();

    private TimeBase() {
    }

    public TimeBase(Date date) {
        this.date = date;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    @Override
    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        int val;
        if (this.isUTC()) {
            new ASN1Header(implicit, FORM, 13L).encode(ostream);
        } else {
            new ASN1Header(implicit, FORM, 15L).encode(ostream);
        }
        boolean i = false;
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(this.date);
        if (this.isUTC()) {
            val = cal.get(1);
            ostream.write(val % 100 / 10 + 48);
            ostream.write(val % 10 + 48);
        } else {
            val = cal.get(1);
            ostream.write(val % 10000 / 1000 + 48);
            ostream.write(val % 1000 / 100 + 48);
            ostream.write(val % 100 / 10 + 48);
            ostream.write(val % 10 + 48);
        }
        val = cal.get(2) + 1;
        Assert._assert(val >= 1 && val <= 12);
        ostream.write(val / 10 + 48);
        ostream.write(val % 10 + 48);
        val = cal.get(5);
        Assert._assert(val >= 1 && val <= 31);
        ostream.write(val / 10 + 48);
        ostream.write(val % 10 + 48);
        val = cal.get(11);
        Assert._assert(val >= 0 && val <= 23);
        ostream.write(val / 10 + 48);
        ostream.write(val % 10 + 48);
        val = cal.get(12);
        Assert._assert(val >= 0 && val <= 59);
        ostream.write(val / 10 + 48);
        ostream.write(val % 10 + 48);
        val = cal.get(13);
        Assert._assert(val >= 0 && val <= 59);
        ostream.write(val / 10 + 48);
        ostream.write(val % 10 + 48);
        ostream.write(90);
    }

    public static abstract class Template {
        protected abstract boolean isUTC();

        protected abstract Tag getTag();

        protected abstract TimeBase generateInstance(Date var1);

        public boolean tagMatch(Tag tag) {
            return this.getTag().equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), istream);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            TimeZone tz;
            int second;
            int year;
            PrintableString.Template pst = new PrintableString.Template();
            PrintableString ps = (PrintableString)pst.decode(implicitTag, istream);
            char[] chars = ps.toCharArray();
            int i = 0;
            if (this.isUTC()) {
                Template.checkBounds(i, 2, chars.length);
                year = (chars[i] - 48) * 10;
                year = (year += chars[i + 1] - 48) < 70 ? (year += 2000) : (year += 1900);
                i += 2;
            } else {
                Template.checkBounds(i, 4, chars.length);
                year = (chars[i] - 48) * 1000;
                year += (chars[i + 1] - 48) * 100;
                year += (chars[i + 2] - 48) * 10;
                Template.checkRange(year += chars[i + 3] - 48, 0, 9999, "year");
                i += 4;
            }
            int month = 0;
            Template.checkBounds(i, 2, chars.length);
            month = (chars[i] - 48) * 10;
            Template.checkRange(month += chars[i + 1] - 48, 1, 12, "month");
            --month;
            Template.checkBounds(i += 2, 2, chars.length);
            int day = (chars[i] - 48) * 10;
            Template.checkRange(day += chars[i + 1] - 48, 1, 31, "day");
            Template.checkBounds(i += 2, 2, chars.length);
            int hour = (chars[i] - 48) * 10;
            Template.checkRange(hour += chars[i + 1] - 48, 0, 23, "hour");
            Template.checkBounds(i += 2, 2, chars.length);
            int minute = (chars[i] - 48) * 10;
            Template.checkRange(minute += chars[i + 1] - 48, 0, 59, "minute");
            if ((i += 2) < chars.length && chars[i] >= '0' && chars[i] <= '9') {
                Template.checkBounds(i, 2, chars.length);
                second = (chars[i] - 48) * 10;
                Template.checkRange(second += chars[i + 1] - 48, 0, 59, "second");
                i += 2;
            } else {
                second = 0;
            }
            if (!this.isUTC()) {
                while (i < chars.length && chars[i] != '+' && chars[i] != '-' && chars[i] != 'Z') {
                    ++i;
                }
            }
            if (i < chars.length) {
                Template.checkBounds(i, 1, chars.length);
                if (chars[i] == '+' || chars[i] == '-') {
                    Template.checkBounds(i + 1, 4, chars.length);
                    int hourOff = (chars[i + 1] - 48) * 10;
                    hourOff += chars[i + 2] - 48;
                    int minOff = (chars[i + 3] - 48) * 10;
                    minOff += chars[i + 4] - 48;
                    Template.checkRange(hourOff, 0, 23, "hour offset");
                    Template.checkRange(minOff, 0, 59, "minute offset");
                    if (chars[i += 5] == '-') {
                        hourOff = -hourOff;
                        minOff = -minOff;
                    }
                    tz = (TimeZone)TimeZone.getTimeZone("GMT").clone();
                    tz.setRawOffset((hourOff * 60 + minOff) * 60 * 1000);
                } else {
                    if (chars[i] != 'Z') throw new InvalidBERException("Invalid character " + chars[i]);
                    ++i;
                    boolean minOff = false;
                    boolean hourOff = false;
                    tz = (TimeZone)TimeZone.getTimeZone("GMT").clone();
                }
            } else {
                if (this.isUTC()) {
                    throw new InvalidBERException("no timezone specified for UTCTime");
                }
                tz = TimeZone.getDefault();
            }
            if (i != chars.length) {
                throw new InvalidBERException("Extra characters at end");
            }
            Calendar cal = Calendar.getInstance(tz);
            cal.set(year, month, day, hour, minute, second);
            return this.generateInstance(cal.getTime());
        }

        private static void checkRange(int val, int low, int high, String field) throws InvalidBERException {
            if (val < low || val > high) {
                throw new InvalidBERException("Invalid " + field);
            }
        }

        private static void checkBounds(int index, int increment, int bound) throws InvalidBERException {
            if (index + increment > bound) {
                throw new InvalidBERException("Too few characters in TimeBase");
            }
        }
    }
}

