/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.IVParameterSpec;

public class EncryptionAlgorithm
extends Algorithm {
    private int blockSize;
    private boolean padded;
    private static Hashtable oidMap = new Hashtable();
    public static final EncryptionAlgorithm RC4 = new EncryptionAlgorithm(8, "RC4", null, 1, false, OBJECT_IDENTIFIER.RSA_CIPHER.subBranch(4L));
    public static final EncryptionAlgorithm DES_ECB = new EncryptionAlgorithm(9, "DES/ECB", null, 8, false, OBJECT_IDENTIFIER.ALGORITHM.subBranch(6L));
    public static final EncryptionAlgorithm DES_CBC = new EncryptionAlgorithm(10, "DES/CBC", IVParameterSpec.class, 8, false, OBJECT_IDENTIFIER.ALGORITHM.subBranch(7L));
    public static final EncryptionAlgorithm DES_CBC_PAD = new EncryptionAlgorithm(11, "DES/CBC/Pad", IVParameterSpec.class, 8, true, null);
    public static final EncryptionAlgorithm DES3_ECB = new EncryptionAlgorithm(12, "DES3/ECB", null, 8, false, null);
    public static final EncryptionAlgorithm DES3_CBC = new EncryptionAlgorithm(13, "DES3/CBC", IVParameterSpec.class, 8, false, OBJECT_IDENTIFIER.RSA_CIPHER.subBranch(7L));
    public static final EncryptionAlgorithm DES3_CBC_PAD = new EncryptionAlgorithm(14, "DES3/CBC/Pad", IVParameterSpec.class, 8, true, null);
    public static final EncryptionAlgorithm RC2_CBC = new EncryptionAlgorithm(30, "RC2/CBC", IVParameterSpec.class, 8, false, OBJECT_IDENTIFIER.RSA_CIPHER.subBranch(2L));

    protected EncryptionAlgorithm(int oidTag, String name, Class paramClass, int blockSize, boolean padded, OBJECT_IDENTIFIER oid) {
        super(oidTag, name, oid, paramClass);
        this.blockSize = blockSize;
        this.padded = padded;
        if (oid != null) {
            oidMap.put(oid, this);
        }
    }

    public static EncryptionAlgorithm fromOID(OBJECT_IDENTIFIER oid) throws NoSuchAlgorithmException {
        Object alg = oidMap.get(oid);
        if (alg == null) {
            throw new NoSuchAlgorithmException();
        }
        return (EncryptionAlgorithm)alg;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public boolean isPadded() {
        return this.padded;
    }

    public native int getIVLength();
}

