/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.DigestAlgorithm;

public class HMACAlgorithm
extends DigestAlgorithm {
    private static Hashtable oidMap = new Hashtable();
    public static final HMACAlgorithm SHA1 = new HMACAlgorithm(27, "SHA-1-HMAC", OBJECT_IDENTIFIER.ALGORITHM.subBranch(26L), 20);

    protected HMACAlgorithm(int oidIndex, String name, OBJECT_IDENTIFIER oid, int outputSize) {
        super(oidIndex, name, oid, outputSize);
        if (oid != null && oidMap.get(oid) == null) {
            oidMap.put(oid, this);
        }
    }

    public static DigestAlgorithm fromOID(OBJECT_IDENTIFIER oid) throws NoSuchAlgorithmException {
        Object alg = oidMap.get(oid);
        if (alg == null) {
            throw new NoSuchAlgorithmException();
        }
        return (HMACAlgorithm)alg;
    }
}

