/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;

public class KeyGenAlgorithm
extends Algorithm {
    private static final OBJECT_IDENTIFIER PKCS5 = OBJECT_IDENTIFIER.PKCS5;
    private static final OBJECT_IDENTIFIER PKCS12_PBE = OBJECT_IDENTIFIER.PKCS12.subBranch(1L);
    private static Hashtable oidMap = new Hashtable();
    private int validStrength;
    public static final KeyGenAlgorithm DES = new KeyGenAlgorithm(15, "DES", 56, null, null);
    public static final KeyGenAlgorithm DES3 = new KeyGenAlgorithm(16, "DES3", 168, null, null);
    public static final KeyGenAlgorithm RC4 = new KeyGenAlgorithm(17, "RC4", -1, null, null);
    public static final KeyGenAlgorithm PBA_SHA1_HMAC = new KeyGenAlgorithm(31, "PBA/SHA1/HMAC", 160, null, PBEKeyGenParams.class);

    protected KeyGenAlgorithm(int oidTag, String name, int validStrength, OBJECT_IDENTIFIER oid, Class paramClass) {
        super(oidTag, name, oid, paramClass);
        this.validStrength = validStrength;
        if (oid != null) {
            oidMap.put(oid, this);
        }
    }

    public static KeyGenAlgorithm fromOID(OBJECT_IDENTIFIER oid) throws NoSuchAlgorithmException {
        Object alg = oidMap.get(oid);
        if (alg == null) {
            throw new NoSuchAlgorithmException(oid.toString());
        }
        return (KeyGenAlgorithm)alg;
    }

    public boolean isValidStrength(int strength) {
        if (this.validStrength == -1) {
            return true;
        }
        return strength == this.validStrength;
    }
}

