/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGeneratorSpi;
import org.mozilla.jss.crypto.TokenException;

public class KeyPairGenerator {
    protected KeyPairAlgorithm algorithm;
    protected KeyPairGeneratorSpi engine;

    public KeyPairGenerator(KeyPairAlgorithm algorithm, KeyPairGeneratorSpi engine) {
        this.algorithm = algorithm;
        this.engine = engine;
    }

    public KeyPair genKeyPair() throws TokenException {
        return this.engine.generateKeyPair();
    }

    public KeyPairAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.engine.initialize(params, random);
    }

    public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.engine.initialize(params, null);
    }

    public void initialize(int strength, SecureRandom random) {
        this.engine.initialize(strength, random);
    }

    public void initialize(int strength) {
        this.engine.initialize(strength, null);
    }

    public boolean keygenOnInternalToken() {
        return this.engine.keygenOnInternalToken();
    }

    public void temporaryPairs(boolean temp) {
        this.engine.temporaryPairs(temp);
    }
}

