/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.util.Password;

public class PBEKeyGenParams
implements AlgorithmParameterSpec {
    private Password pass;
    private byte[] salt;
    private int iterations;
    private static final int DEFAULT_SALT_LENGTH = 8;
    private static final int DEFAULT_ITERATIONS = 1;

    private PBEKeyGenParams() {
    }

    public PBEKeyGenParams(Password pass, byte[] salt, int iterations) {
        if (pass == null || salt == null) {
            throw new NullPointerException();
        }
        this.pass = (Password)pass.clone();
        this.salt = salt;
        this.iterations = iterations;
    }

    public Password getPassword() {
        return this.pass;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void clear() {
        this.pass.clear();
    }

    protected void finalize() throws Throwable {
        this.pass.clear();
    }
}

