/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.spec.DSAParameterSpec;
import org.mozilla.jss.crypto.PQGParamGenException;
import org.mozilla.jss.util.Assert;

public class PQGParams
extends DSAParameterSpec {
    private BigInteger seed;
    private int counter;
    private BigInteger H;

    public PQGParams(BigInteger P, BigInteger Q, BigInteger G, BigInteger seed, int counter, BigInteger H) {
        super(P, Q, G);
        this.seed = seed;
        this.counter = counter;
        this.H = H;
    }

    public static PQGParams generate(int keySize) throws InvalidParameterException, PQGParamGenException {
        PQGParams pqg = PQGParams.generateNative(keySize);
        if (!pqg.paramsAreValid()) {
            throw new PQGParamGenException("Generated parameters did not verify correctly");
        }
        return pqg;
    }

    private static native PQGParams generateNative(int var0) throws InvalidParameterException, PQGParamGenException;

    public static PQGParams generate(int keySize, int seedBytes) throws InvalidParameterException, PQGParamGenException {
        PQGParams pqg = PQGParams.generateNative(keySize, seedBytes);
        if (!pqg.paramsAreValid()) {
            throw new PQGParamGenException("Generated parameters did not verify correctly");
        }
        return pqg;
    }

    private static native PQGParams generateNative(int var0, int var1) throws InvalidParameterException, PQGParamGenException;

    public static byte[] BigIntegerToUnsignedByteArray(BigInteger big) {
        byte[] ret;
        Assert._assert(big.signum() != -1);
        if (big.bitLength() % 8 == 0) {
            byte[] array = big.toByteArray();
            Assert._assert(array[0] == 0);
            ret = new byte[array.length - 1];
            System.arraycopy(array, 1, ret, 0, ret.length);
        } else {
            ret = big.toByteArray();
        }
        return ret;
    }

    public boolean paramsAreValid() {
        return this.paramsAreValidNative(PQGParams.BigIntegerToUnsignedByteArray(this.getP()), PQGParams.BigIntegerToUnsignedByteArray(this.getQ()), PQGParams.BigIntegerToUnsignedByteArray(this.getG()), PQGParams.BigIntegerToUnsignedByteArray(this.seed), this.counter, PQGParams.BigIntegerToUnsignedByteArray(this.H));
    }

    private native boolean paramsAreValidNative(byte[] var1, byte[] var2, byte[] var3, byte[] var4, int var5, byte[] var6);

    public BigInteger getSeed() {
        return this.seed;
    }

    public int getCounter() {
        return this.counter;
    }

    public BigInteger getH() {
        return this.H;
    }
}

