/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.util.Assert;

public interface PrivateKey
extends java.security.PrivateKey {
    public static final Type RSA = Type.RSA;
    public static final Type DSA = Type.DSA;

    public Type getType();

    public byte[] getUniqueID() throws TokenException;

    public int getStrength();

    public CryptoToken getOwningToken();

    public static final class Type {
        private OBJECT_IDENTIFIER oid;
        private String name;
        private static Hashtable oidMap = new Hashtable();
        public static final Type RSA = new Type(OBJECT_IDENTIFIER.PKCS1.subBranch(1L), "RSA");
        public static final Type DSA = new Type(Algorithm.ANSI_X9_ALGORITHM.subBranch(1L), "DSA");

        private Type() {
        }

        private Type(OBJECT_IDENTIFIER oid, String name) {
            this.oid = oid;
            this.name = name;
            Type old = oidMap.put(oid, this);
            Assert._assert(old == null);
        }

        public static Type fromOID(OBJECT_IDENTIFIER oid) throws NoSuchAlgorithmException {
            Object obj = oidMap.get(oid);
            if (obj == null) {
                throw new NoSuchAlgorithmException();
            }
            return (Type)obj;
        }

        public String toString() {
            return this.name;
        }

        public OBJECT_IDENTIFIER toOID() {
            return this.oid;
        }
    }
}

