/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.HMACAlgorithm;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.util.Assert;

final class KeyType {
    protected Algorithm[] algorithms;
    protected String name;
    protected static Hashtable algHash = new Hashtable();
    public static final KeyType NULL = new KeyType(new Algorithm[0], "NULL");
    public static final KeyType RSA = new KeyType(new Algorithm[]{SignatureAlgorithm.RSASignature, SignatureAlgorithm.RSASignatureWithMD2Digest, SignatureAlgorithm.RSASignatureWithMD5Digest, SignatureAlgorithm.RSASignatureWithSHA1Digest, KeyWrapAlgorithm.RSA}, "RSA");
    public static final KeyType DSA = new KeyType(new Algorithm[]{SignatureAlgorithm.DSASignature, SignatureAlgorithm.DSASignatureWithSHA1Digest}, "DSA");
    public static final KeyType FORTEZZA = new KeyType(new Algorithm[0], "FORTEZZA");
    public static final KeyType DH = new KeyType(new Algorithm[0], "DH");
    public static final KeyType KEA = new KeyType(new Algorithm[0], "KEA");
    public static final KeyType DES = new KeyType(new Algorithm[]{KeyWrapAlgorithm.DES_ECB, KeyWrapAlgorithm.DES_CBC, KeyWrapAlgorithm.DES_CBC_PAD, EncryptionAlgorithm.DES_ECB, EncryptionAlgorithm.DES_CBC, EncryptionAlgorithm.DES_CBC_PAD}, "DES");
    public static final KeyType DES3 = new KeyType(new Algorithm[]{KeyWrapAlgorithm.DES3_ECB, KeyWrapAlgorithm.DES3_CBC, KeyWrapAlgorithm.DES3_CBC_PAD, EncryptionAlgorithm.DES3_ECB, EncryptionAlgorithm.DES3_CBC, EncryptionAlgorithm.DES3_CBC_PAD}, "DES");
    public static final KeyType RC4 = new KeyType(new Algorithm[]{EncryptionAlgorithm.RC4}, "RC4");
    public static final KeyType RC2 = new KeyType(new Algorithm[]{EncryptionAlgorithm.RC2_CBC}, "RC2");
    public static final KeyType SHA1_HMAC = new KeyType(new Algorithm[]{HMACAlgorithm.SHA1}, "SHA1_HMAC");

    protected KeyType() {
    }

    protected KeyType(Algorithm[] algs, String name) {
        Assert._assert(algs != null);
        this.algorithms = (Algorithm[])algs.clone();
        for (int i = 0; i < this.algorithms.length; ++i) {
            Assert._assert(!algHash.containsKey(this.algorithms[i]));
            algHash.put(this.algorithms[i], this);
        }
        this.name = name;
    }

    public Algorithm[] supportedAlgorithms() {
        return this.algorithms;
    }

    public static KeyType getKeyTypeFromAlgorithm(Algorithm alg) throws NoSuchAlgorithmException {
        Assert._assert(alg != null);
        Object obj = algHash.get(alg);
        if (obj == null) {
            throw new NoSuchAlgorithmException();
        }
        Assert._assert(obj instanceof KeyType);
        return (KeyType)obj;
    }
}

