/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.math.BigInteger;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.CertProxy;
import org.mozilla.jss.util.Assert;

public class PK11Cert
implements X509Certificate {
    protected CertProxy certProxy;

    @Override
    public native byte[] getEncoded() throws CertificateEncodingException;

    @Override
    public native String getNickname();

    @Override
    public Principal getSubjectDN() {
        return new StringPrincipal(this.getSubjectDNString());
    }

    @Override
    public Principal getIssuerDN() {
        return new StringPrincipal(this.getIssuerDNString());
    }

    @Override
    public BigInteger getSerialNumber() {
        return new BigInteger(this.getSerialNumberByteArray());
    }

    protected native byte[] getSerialNumberByteArray();

    protected native String getSubjectDNString();

    protected native String getIssuerDNString();

    @Override
    public native PublicKey getPublicKey();

    @Override
    public native int getVersion();

    protected native byte[] getUniqueID();

    protected native CryptoToken getOwningToken();

    protected native void setTrust(int var1, int var2);

    protected native int getTrust(int var1);

    PK11Cert(byte[] pointer) {
        Assert._assert(pointer != null);
        this.certProxy = new CertProxy(pointer);
    }

    protected static class StringPrincipal
    implements Principal {
        protected String str;

        public StringPrincipal(String str) {
            this.str = str;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof StringPrincipal)) {
                return false;
            }
            return this.getName().equals(((StringPrincipal)other).getName());
        }

        @Override
        public String getName() {
            return this.str;
        }

        @Override
        public int hashCode() {
            return this.str.hashCode();
        }

        @Override
        public String toString() {
            return this.str;
        }
    }
}

