/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.io.CharConversionException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.PK11SymKey;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.UTF8Converter;

public final class PK11KeyGenerator
implements KeyGenerator {
    private PK11Token token;
    private KeyGenAlgorithm algorithm;
    private int strength = 0;
    private AlgorithmParameterSpec parameters;
    private KeyGenerator.CharToByteConverter charToByte;

    private PK11KeyGenerator() {
    }

    PK11KeyGenerator(PK11Token token, KeyGenAlgorithm algorithm) {
        if (token == null || algorithm == null) {
            throw new NullPointerException();
        }
        this.token = token;
        this.algorithm = algorithm;
        this.charToByte = new KeyGenerator.CharToByteConverter(){

            @Override
            public byte[] convert(char[] chars) throws CharConversionException {
                return UTF8Converter.UnicodeToUTF8(chars);
            }
        };
    }

    @Override
    public void setCharToByteConverter(KeyGenerator.CharToByteConverter charToByte) {
        if (charToByte == null) {
            throw new IllegalArgumentException("CharToByteConverter is null");
        }
        this.charToByte = charToByte;
    }

    @Override
    public void initialize(int strength) throws InvalidAlgorithmParameterException {
        if (PBEKeyGenParams.class.equals((Object)this.algorithm.getParameterClass())) {
            throw new InvalidAlgorithmParameterException("PBE keygen algorithms require PBEKeyGenParams ");
        }
        if (!this.algorithm.isValidStrength(strength)) {
            throw new InvalidAlgorithmParameterException(strength + " is not a valid strength for " + this.algorithm);
        }
        if (strength % 8 != 0) {
            throw new InvalidAlgorithmParameterException("Key strength must be divisible by 8");
        }
        this.strength = strength;
    }

    @Override
    public void initialize(AlgorithmParameterSpec parameters) throws InvalidAlgorithmParameterException {
        if (PBEKeyGenParams.class.equals((Object)this.algorithm.getParameterClass())) {
            if (!(parameters instanceof PBEKeyGenParams)) {
                throw new InvalidAlgorithmParameterException("PBE keygen algorithms require PBEKeyGenParams");
            }
        } else {
            throw new InvalidAlgorithmParameterException(this.algorithm + " does not take any parameters");
        }
        this.parameters = parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SymmetricKey generate() throws IllegalStateException, TokenException, CharConversionException {
        if (PBEKeyGenParams.class.equals((Object)this.algorithm.getParameterClass())) {
            SymmetricKey symmetricKey;
            block7: {
                if (this.parameters == null || !(this.parameters instanceof PBEKeyGenParams)) {
                    throw new IllegalStateException("PBE keygen algorithms require PBEKeyGenParams");
                }
                PBEKeyGenParams kgp = (PBEKeyGenParams)this.parameters;
                byte[] pwbytes = null;
                try {
                    pwbytes = this.charToByte.convert(kgp.getPassword().getChars());
                    symmetricKey = PK11KeyGenerator.generatePBE(this.token, this.algorithm, pwbytes, kgp.getSalt(), kgp.getIterations());
                    if (pwbytes == null) break block7;
                }
                catch (Throwable throwable) {
                    if (pwbytes != null) {
                        Password.wipeBytes(pwbytes);
                    }
                    throw throwable;
                }
                Password.wipeBytes(pwbytes);
            }
            return symmetricKey;
        }
        if (this.algorithm == KeyGenAlgorithm.RC4) {
            if (this.strength == 0) {
                throw new IllegalStateException("RC4 keygen must be initialized with a strength");
            }
            return PK11KeyGenerator.generateNormal(this.token, this.algorithm, this.strength);
        }
        return PK11KeyGenerator.generateNormal(this.token, this.algorithm, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] generatePBE_IV() throws TokenException, CharConversionException {
        if (PBEKeyGenParams.class.equals((Object)this.algorithm.getParameterClass())) {
            byte[] byArray;
            block5: {
                if (this.parameters == null || !(this.parameters instanceof PBEKeyGenParams)) {
                    throw new IllegalStateException("PBE keygen algorithms require PBEKeyGenParams");
                }
                PBEKeyGenParams kgp = (PBEKeyGenParams)this.parameters;
                byte[] pwbytes = null;
                try {
                    pwbytes = this.charToByte.convert(kgp.getPassword().getChars());
                    byArray = PK11KeyGenerator.generatePBE_IV(this.algorithm, pwbytes, kgp.getSalt(), kgp.getIterations());
                    if (pwbytes == null) break block5;
                }
                catch (Throwable throwable) {
                    if (pwbytes != null) {
                        Password.wipeBytes(pwbytes);
                    }
                    throw throwable;
                }
                Password.wipeBytes(pwbytes);
            }
            return byArray;
        }
        throw new IllegalStateException("IV generation can only be performed by PBE algorithms");
    }

    private static native byte[] generatePBE_IV(KeyGenAlgorithm var0, byte[] var1, byte[] var2, int var3) throws TokenException;

    @Override
    public SymmetricKey clone(SymmetricKey key) throws SymmetricKey.NotExtractableException, InvalidKeyException, TokenException {
        return PK11KeyGenerator.clone(key, this.token);
    }

    public static SymmetricKey clone(SymmetricKey key, PK11Token token) throws SymmetricKey.NotExtractableException, InvalidKeyException, TokenException {
        if (!(key instanceof PK11SymKey)) {
            throw new InvalidKeyException("Key is not a PKCS #11 key");
        }
        return PK11KeyGenerator.nativeClone(token, key);
    }

    private static native SymmetricKey nativeClone(PK11Token var0, SymmetricKey var1) throws SymmetricKey.NotExtractableException, TokenException;

    private static native SymmetricKey generateNormal(PK11Token var0, KeyGenAlgorithm var1, int var2) throws TokenException;

    private static native SymmetricKey generatePBE(PK11Token var0, KeyGenAlgorithm var1, byte[] var2, byte[] var3, int var4) throws TokenException;
}

