/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.KeyType;
import org.mozilla.jss.pkcs11.PK11Key;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.pkcs11.PrivateKeyProxy;
import org.mozilla.jss.util.Assert;

public class PK11PrivKey
extends PK11Key
implements PrivateKey {
    protected PK11PrivKey(byte[] pointer) {
        Assert._assert(pointer != null);
        this.keyProxy = new PrivateKeyProxy(pointer);
    }

    public native void verifyKeyIsOnToken(PK11Token var1) throws NoSuchItemOnTokenException;

    @Override
    public native CryptoToken getOwningToken();

    @Override
    public native byte[] getUniqueID() throws TokenException;

    public native KeyType getKeyType();

    @Override
    public PrivateKey.Type getType() {
        KeyType kt = this.getKeyType();
        if (kt == KeyType.RSA) {
            return PrivateKey.Type.RSA;
        }
        Assert._assert(kt == KeyType.DSA);
        return PrivateKey.Type.DSA;
    }

    @Override
    public native int getStrength();
}

