/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.security.PublicKey;
import org.mozilla.jss.crypto.InvalidKeyFormatException;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.pkcs11.KeyType;
import org.mozilla.jss.pkcs11.PK11Key;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.pkcs11.PublicKeyProxy;
import org.mozilla.jss.util.Assert;

public class PK11PubKey
extends PK11Key
implements PublicKey {
    protected PK11PubKey(byte[] pointer) {
        Assert._assert(pointer != null);
        this.keyProxy = new PublicKeyProxy(pointer);
    }

    public native void verifyKeyIsOnToken(PK11Token var1) throws NoSuchItemOnTokenException;

    public native KeyType getKeyType();

    public static PK11PubKey fromRaw(PrivateKey.Type type, byte[] rawKey) throws InvalidKeyFormatException {
        if (type == PrivateKey.RSA) {
            return PK11PubKey.RSAFromRaw(rawKey);
        }
        Assert._assert(type == PrivateKey.DSA);
        return PK11PubKey.DSAFromRaw(rawKey);
    }

    private static native PK11PubKey RSAFromRaw(byte[] var0);

    private static native PK11PubKey DSAFromRaw(byte[] var0);

    @Override
    public native byte[] getEncoded();

    @Override
    public String getFormat() {
        return "X.509";
    }
}

