/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.pkcs11.KeyType;
import org.mozilla.jss.pkcs11.SymKeyProxy;
import org.mozilla.jss.util.Assert;

public final class PK11SymKey
implements SymmetricKey {
    private SymKeyProxy keyProxy;

    protected PK11SymKey(byte[] pointer) {
        Assert._assert(pointer != null);
        this.keyProxy = new SymKeyProxy(pointer);
    }

    @Override
    public SymmetricKey.Type getType() {
        KeyType kt = this.getKeyType();
        if (kt == KeyType.DES) {
            return DES;
        }
        if (kt == KeyType.DES3) {
            return DES3;
        }
        if (kt == KeyType.RC4) {
            return RC4;
        }
        if (kt == KeyType.RC2) {
            return RC2;
        }
        Assert.notReached("Unrecognized key type");
        return DES;
    }

    @Override
    public native CryptoToken getOwningToken();

    @Override
    public native int getStrength();

    @Override
    public native byte[] getKeyData() throws SymmetricKey.NotExtractableException;

    public native KeyType getKeyType();
}

