/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs7;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkcs7.DigestedData;
import org.mozilla.jss.pkcs7.EncryptedData;
import org.mozilla.jss.pkcs7.EnvelopedData;
import org.mozilla.jss.pkcs7.SignedAndEnvelopedData;
import org.mozilla.jss.pkcs7.SignedData;
import org.mozilla.jss.util.Assert;

public class ContentInfo
implements ASN1Value {
    public static final Tag TAG = SEQUENCE.TAG;
    public static OBJECT_IDENTIFIER DATA = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 1L});
    public static OBJECT_IDENTIFIER SIGNED_DATA = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 2L});
    public static OBJECT_IDENTIFIER ENVELOPED_DATA = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 3L});
    public static OBJECT_IDENTIFIER SIGNED_AND_ENVELOPED_DATA = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 4L});
    public static OBJECT_IDENTIFIER DIGESTED_DATA = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 5L});
    public static OBJECT_IDENTIFIER ENCRYPTED_DATA = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 6L});
    private OBJECT_IDENTIFIER contentType;
    private ANY content;
    private SEQUENCE sequence = new SEQUENCE();
    private static Template templateInstance = new Template();

    private ContentInfo() {
    }

    public ContentInfo(OBJECT_IDENTIFIER contentType, ASN1Value content) {
        this.contentType = contentType;
        this.sequence.addElement(contentType);
        if (content != null) {
            if (content instanceof ANY) {
                this.content = (ANY)content;
            } else {
                try {
                    this.content = (ANY)ASN1Util.decode(ANY.getTemplate(), ASN1Util.encode(content));
                }
                catch (InvalidBERException e) {
                    Assert.notReached("InvalidBERException while convertingASN1Value to ANY");
                }
            }
            this.sequence.addElement(new EXPLICIT(new Tag(0L), content));
        }
    }

    public ContentInfo(byte[] data) {
        this(DATA, new OCTET_STRING(data));
    }

    public ContentInfo(SignedData sd) {
        this(SIGNED_DATA, sd);
    }

    public ContentInfo(EnvelopedData ed) {
        this(ENVELOPED_DATA, ed);
    }

    public ContentInfo(SignedAndEnvelopedData sed) {
        this(SIGNED_AND_ENVELOPED_DATA, sed);
    }

    public ContentInfo(DigestedData dd) {
        this(DIGESTED_DATA, dd);
    }

    public ContentInfo(EncryptedData ed) {
        this(ENCRYPTED_DATA, ed);
    }

    public OBJECT_IDENTIFIER getContentType() {
        return this.contentType;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public ASN1Value getInterpretedContent() throws InvalidBERException {
        if (this.contentType.equals(DATA)) {
            return this.content.decodeWith(new OCTET_STRING.Template());
        }
        if (this.contentType.equals(SIGNED_DATA)) {
            return this.content.decodeWith(new SignedData.Template());
        }
        if (this.contentType.equals(ENVELOPED_DATA)) {
            return this.content.decodeWith(new EnvelopedData.Template());
        }
        if (this.contentType.equals(SIGNED_AND_ENVELOPED_DATA)) {
            return this.content.decodeWith(new SignedAndEnvelopedData.Template());
        }
        if (this.contentType.equals(DIGESTED_DATA)) {
            return this.content.decodeWith(new DigestedData.Template());
        }
        if (this.contentType.equals(ENCRYPTED_DATA)) {
            return this.content.decodeWith(new EncryptedData.Template());
        }
        return this.content;
    }

    public ANY getContent() {
        return this.content;
    }

    public byte[] getEncoded() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encode(baos);
        return baos.toByteArray();
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        @Override
        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        public Template() {
            this.seqt.addElement(new OBJECT_IDENTIFIER.Template());
            this.seqt.addOptionalElement(new EXPLICIT.Template(new Tag(0L), new ANY.Template()));
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            Assert._assert(seq.size() == 2);
            ASN1Value content = seq.elementAt(1) == null ? null : ((EXPLICIT)seq.elementAt(1)).getContent();
            return new ContentInfo((OBJECT_IDENTIFIER)seq.elementAt(0), content);
        }
    }
}

