/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.util.Assert;

public class DigestInfo
implements ASN1Value {
    private AlgorithmIdentifier digestAlgorithm;
    private OCTET_STRING digest;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private DigestInfo() {
    }

    public DigestInfo(AlgorithmIdentifier digestAlgorithm, OCTET_STRING digest) {
        if (digestAlgorithm == null || digest == null) {
            throw new IllegalArgumentException();
        }
        this.sequence = new SEQUENCE();
        this.digestAlgorithm = digestAlgorithm;
        this.sequence.addElement(digestAlgorithm);
        this.digest = digest;
        this.sequence.addElement(digest);
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public OCTET_STRING getDigest() {
        return this.digest;
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DigestInfo)) {
            return false;
        }
        DigestInfo di = (DigestInfo)obj;
        return DigestInfo.byteArraysAreSame(di.digest.toByteArray(), this.digest.toByteArray());
    }

    private static boolean byteArraysAreSame(byte[] left, byte[] right) {
        Assert._assert(left != null && right != null);
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (left[i] == right[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(OCTET_STRING.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream ostream) throws InvalidBERException, IOException {
            return this.decode(TAG, ostream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream ostream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, ostream);
            return new DigestInfo((AlgorithmIdentifier)seq.elementAt(0), (OCTET_STRING)seq.elementAt(1));
        }
    }
}

