/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkcs7.EncryptedContentInfo;
import org.mozilla.jss.pkcs7.RecipientInfo;
import org.mozilla.jss.util.Assert;

public class EnvelopedData
implements ASN1Value {
    public static final Tag TAG = SEQUENCE.TAG;
    private INTEGER version;
    private SET recipientInfos;
    private EncryptedContentInfo encryptedContentInfo;
    private SEQUENCE sequence = new SEQUENCE();

    @Override
    public Tag getTag() {
        return TAG;
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public SET getRecipientInfos() {
        return this.recipientInfos;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    private EnvelopedData() {
    }

    public EnvelopedData(INTEGER version, SET recipientInfos, EncryptedContentInfo encryptedContentInfo) {
        this.version = version;
        this.recipientInfos = recipientInfos;
        this.encryptedContentInfo = encryptedContentInfo;
        this.sequence.addElement(version);
        this.sequence.addElement(recipientInfos);
        this.sequence.addElement(encryptedContentInfo);
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    @Override
    public void encode(Tag tag, OutputStream ostream) throws IOException {
        this.sequence.encode(tag, ostream);
    }

    public static class Template
    implements ASN1Template {
        public Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.Template seqt = new SEQUENCE.Template();
            seqt.addElement(new INTEGER.Template());
            seqt.addElement(new SET.OF_Template(new RecipientInfo.Template()));
            seqt.addElement(new EncryptedContentInfo.Template());
            SEQUENCE seq = (SEQUENCE)seqt.decode(implicitTag, istream);
            Assert._assert(seq.size() == 3);
            return new EnvelopedData((INTEGER)seq.elementAt(0), (SET)seq.elementAt(1), (EncryptedContentInfo)seq.elementAt(2));
        }
    }
}

