/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs7;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkcs7.ContentInfo;
import org.mozilla.jss.pkcs7.SignerInfo;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.util.Assert;

public class SignedData
implements ASN1Value {
    private INTEGER version;
    private SET digestAlgorithms;
    private ContentInfo contentInfo;
    private SET certificates;
    private SET crls;
    private SET signerInfos;
    private static final INTEGER VERSION = new INTEGER(1L);
    static final Tag TAG = SEQUENCE.TAG;

    private static void verifyNotNull(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public SET getDigestAlgorithmIdentifiers() {
        return this.digestAlgorithms;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public SET getCertificates() {
        return this.certificates;
    }

    public boolean hasCertificates() {
        return this.certificates != null;
    }

    public SET getCrls() {
        return this.crls;
    }

    public boolean hasCrls() {
        return this.crls != null;
    }

    public SET getSignerInfos() {
        return this.signerInfos;
    }

    public SignedData(SET digestAlgorithms, ContentInfo contentInfo, SET certificates, SET crls, SET signerInfos) {
        this.version = VERSION;
        this.digestAlgorithms = digestAlgorithms == null ? new SET() : digestAlgorithms;
        SignedData.verifyNotNull(contentInfo);
        this.contentInfo = contentInfo;
        this.certificates = certificates;
        this.crls = crls;
        this.signerInfos = signerInfos == null ? new SET() : signerInfos;
    }

    public SignedData(SET digestAlgorithms, ContentInfo contentInfo, SET certificates, SET crls, SET signerInfos, INTEGER vers) {
        this.version = vers;
        this.digestAlgorithms = digestAlgorithms == null ? new SET() : digestAlgorithms;
        SignedData.verifyNotNull(contentInfo);
        this.contentInfo = contentInfo;
        this.certificates = certificates;
        this.crls = crls;
        this.signerInfos = signerInfos == null ? new SET() : signerInfos;
    }

    SignedData(INTEGER version, SET digestAlgorithms, ContentInfo contentInfo, SET certificates, SET crls, SET signerInfos) {
        SignedData.verifyNotNull(version);
        this.version = version;
        SignedData.verifyNotNull(digestAlgorithms);
        this.digestAlgorithms = digestAlgorithms;
        SignedData.verifyNotNull(contentInfo);
        this.contentInfo = contentInfo;
        this.certificates = certificates;
        this.crls = crls;
        SignedData.verifyNotNull(signerInfos);
        this.signerInfos = signerInfos;
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public byte[] getEncoded() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encode(baos);
        return baos.toByteArray();
    }

    @Override
    public void encode(Tag tag, OutputStream ostream) throws IOException {
        SEQUENCE sequence = new SEQUENCE();
        sequence.addElement(this.version);
        sequence.addElement(this.digestAlgorithms);
        sequence.addElement(this.contentInfo);
        if (this.certificates != null) {
            sequence.addElement(new Tag(0L), this.certificates);
        }
        if (this.crls != null) {
            sequence.addElement(new Tag(1L), this.crls);
        }
        sequence.addElement(this.signerInfos);
        sequence.encode(tag, ostream);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(new SET.OF_Template(AlgorithmIdentifier.getTemplate()));
            this.seqt.addElement(ContentInfo.getTemplate());
            this.seqt.addOptionalElement(new Tag(0L), new SET.OF_Template(Certificate.getTemplate()));
            this.seqt.addOptionalElement(new Tag(1L), new SET.OF_Template(ANY.getTemplate()));
            this.seqt.addElement(new SET.OF_Template(SignerInfo.getTemplate()));
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            Assert._assert(seq.size() == 6);
            return new SignedData((INTEGER)seq.elementAt(0), (SET)seq.elementAt(1), (ContentInfo)seq.elementAt(2), (SET)seq.elementAt(3), (SET)seq.elementAt(4), (SET)seq.elementAt(5));
        }
    }
}

