/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.manage.CryptoManager;
import org.mozilla.jss.pkcs7.Attribute;
import org.mozilla.jss.pkcs7.ContentInfo;
import org.mozilla.jss.pkcs7.IssuerAndSerialNumber;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.util.Assert;

public class SignerInfo
implements ASN1Value {
    private static final OBJECT_IDENTIFIER CONTENT_TYPE = OBJECT_IDENTIFIER.PKCS.subBranch(9L).subBranch(3L);
    private static final OBJECT_IDENTIFIER MESSAGE_DIGEST = OBJECT_IDENTIFIER.PKCS.subBranch(9L).subBranch(4L);
    private INTEGER version;
    private IssuerAndSerialNumber issuerAndSerialNumber;
    private AlgorithmIdentifier digestAlgorithm;
    private SET authenticatedAttributes;
    private AlgorithmIdentifier digestEncryptionAlgorithm;
    private OCTET_STRING encryptedDigest;
    private SET unauthenticatedAttributes;
    private static final INTEGER VERSION = new INTEGER(1L);
    private static final Tag TAG = SEQUENCE.TAG;
    private static Template templateInstance = new Template();

    public INTEGER getVersion() {
        return this.version;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public DigestAlgorithm getDigestAlgorithm() throws NoSuchAlgorithmException {
        return DigestAlgorithm.fromOID(this.digestAlgorithm.getOID());
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifer() {
        return this.digestAlgorithm;
    }

    public SET getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public boolean hasAuthenticatedAttributes() {
        return this.authenticatedAttributes != null;
    }

    public SignatureAlgorithm getDigestEncryptionAlgorithm() throws NoSuchAlgorithmException {
        return SignatureAlgorithm.fromOID(this.digestEncryptionAlgorithm.getOID());
    }

    public AlgorithmIdentifier getDigestEncryptionAlgorithmIdentifier() {
        return this.digestEncryptionAlgorithm;
    }

    public byte[] getEncryptedDigest() {
        return this.encryptedDigest.toByteArray();
    }

    public SET getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public boolean hasUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes != null;
    }

    public SignerInfo(IssuerAndSerialNumber issuerAndSerialNumber, SET authenticatedAttributes, SET unauthenticatedAttributes, OBJECT_IDENTIFIER contentType, byte[] messageDigest, SignatureAlgorithm signingAlg, PrivateKey signingKey) throws InvalidKeyException, NoSuchAlgorithmException, CryptoManager.NotInitializedException, SignatureException, TokenException {
        byte[] toBeSigned;
        this.version = VERSION;
        this.issuerAndSerialNumber = issuerAndSerialNumber;
        this.digestAlgorithm = new AlgorithmIdentifier(signingAlg.getDigestAlg().toOID(), null);
        if (!contentType.equals(ContentInfo.DATA)) {
            if (authenticatedAttributes == null) {
                authenticatedAttributes = new SET();
            }
            Attribute attrib = new Attribute(CONTENT_TYPE, ContentInfo.DATA);
            authenticatedAttributes.addElement(attrib);
            attrib = new Attribute(MESSAGE_DIGEST, new OCTET_STRING(messageDigest));
            authenticatedAttributes.addElement(attrib);
        }
        this.digestEncryptionAlgorithm = new AlgorithmIdentifier(signingAlg.getRawAlg().toOID(), null);
        if (authenticatedAttributes != null) {
            Assert._assert(authenticatedAttributes.size() >= 2);
            this.authenticatedAttributes = authenticatedAttributes;
        }
        byte[] digest = null;
        DigestAlgorithm digestAlg = signingAlg.getDigestAlg();
        if (authenticatedAttributes == null) {
            digest = messageDigest;
        } else {
            byte[] enc = ASN1Util.encode(authenticatedAttributes);
            MessageDigest md = MessageDigest.getInstance(digestAlg.toString());
            digest = md.digest(enc);
        }
        if (signingAlg.getRawAlg() == SignatureAlgorithm.RSASignature) {
            SEQUENCE digestInfo = new SEQUENCE();
            AlgorithmIdentifier digestAlgId = new AlgorithmIdentifier(digestAlg.toOID(), null);
            digestInfo.addElement(digestAlgId);
            digestInfo.addElement(new OCTET_STRING(digest));
            toBeSigned = ASN1Util.encode(digestInfo);
        } else {
            toBeSigned = digest;
        }
        CryptoToken token = signingKey.getOwningToken();
        Signature sig = token.getSignatureContext(signingAlg.getRawAlg());
        sig.initSign(signingKey);
        sig.update(toBeSigned);
        this.encryptedDigest = new OCTET_STRING(sig.sign());
        if (unauthenticatedAttributes != null) {
            this.unauthenticatedAttributes = unauthenticatedAttributes;
        }
    }

    SignerInfo(INTEGER version, IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmIdentifier digestAlgorithm, SET authenticatedAttributes, AlgorithmIdentifier digestEncryptionAlgorithm, byte[] encryptedDigest, SET unauthenticatedAttributes) {
        this.version = version;
        this.issuerAndSerialNumber = issuerAndSerialNumber;
        this.digestAlgorithm = digestAlgorithm;
        this.authenticatedAttributes = authenticatedAttributes;
        this.digestEncryptionAlgorithm = digestEncryptionAlgorithm;
        this.encryptedDigest = new OCTET_STRING(encryptedDigest);
        this.unauthenticatedAttributes = unauthenticatedAttributes;
    }

    public void verify(byte[] messageDigest, OBJECT_IDENTIFIER contentType) throws CryptoManager.NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, TokenException, SignatureException, ObjectNotFoundException {
        CryptoManager cm = CryptoManager.getInstance();
        X509Certificate cert = cm.findCertByIssuerAndSerialNumber(ASN1Util.encode(this.issuerAndSerialNumber.getIssuer()), this.issuerAndSerialNumber.getSerialNumber());
        this.verify(messageDigest, contentType, cert.getPublicKey());
    }

    public void verify(byte[] messageDigest, OBJECT_IDENTIFIER contentType, PublicKey pubkey) throws CryptoManager.NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, TokenException, SignatureException {
        if (this.authenticatedAttributes == null) {
            this.verifyWithoutAuthenticatedAttributes(messageDigest, contentType, pubkey);
        } else {
            this.verifyWithAuthenticatedAttributes(messageDigest, contentType, pubkey);
        }
    }

    private void verifyWithoutAuthenticatedAttributes(byte[] messageDigest, OBJECT_IDENTIFIER contentType, PublicKey pubkey) throws CryptoManager.NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, TokenException, SignatureException {
        byte[] toBeVerified;
        if (!contentType.equals(ContentInfo.DATA)) {
            throw new SignatureException("Content-Type is not DATA, but there are no authenticated attributes");
        }
        SignatureAlgorithm sigAlg = SignatureAlgorithm.fromOID(this.digestEncryptionAlgorithm.getOID());
        if (sigAlg.getRawAlg() == SignatureAlgorithm.RSASignature) {
            SEQUENCE digestInfo = new SEQUENCE();
            digestInfo.addElement(this.digestAlgorithm.getOID());
            digestInfo.addElement(new OCTET_STRING(messageDigest));
            toBeVerified = ASN1Util.encode(digestInfo);
        } else {
            toBeVerified = messageDigest;
        }
        CryptoToken token = CryptoManager.getInstance().getInternalCryptoToken();
        Signature sig = token.getSignatureContext(sigAlg);
        sig.initVerify(pubkey);
        sig.update(toBeVerified);
        if (sig.verify(this.encryptedDigest.toByteArray())) {
            return;
        }
        throw new SignatureException("Encrypted message digest parameter does not match encrypted digest in SignerInfo");
    }

    private void verifyWithAuthenticatedAttributes(byte[] messageDigest, OBJECT_IDENTIFIER contentType, PublicKey pubkey) throws CryptoManager.NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, TokenException, SignatureException {
        byte[] toBeVerified;
        byte[] toBeDigested;
        int numAttrib = this.authenticatedAttributes.size();
        if (numAttrib < 2) {
            throw new SignatureException("At least two authenticated attributes must be present: content-type and message-digest");
        }
        boolean foundContentType = false;
        boolean foundMessageDigest = false;
        for (int i = 0; i < numAttrib; ++i) {
            byte[] mdigest;
            block24: {
                ASN1Value val;
                SET vals;
                if (!(this.authenticatedAttributes.elementAt(i) instanceof Attribute)) {
                    throw new SignatureException("Element of authenticatedAttributes is not an Attribute");
                }
                Attribute attrib = (Attribute)this.authenticatedAttributes.elementAt(i);
                if (attrib.getType().equals(CONTENT_TYPE)) {
                    OBJECT_IDENTIFIER ctype;
                    block23: {
                        vals = attrib.getValues();
                        if (vals.size() != 1) {
                            throw new SignatureException("Content-Type attribute  does not have exactly one value");
                        }
                        val = vals.elementAt(0);
                        try {
                            if (val instanceof OBJECT_IDENTIFIER) {
                                ctype = (OBJECT_IDENTIFIER)val;
                                break block23;
                            }
                            if (val instanceof ANY) {
                                ctype = (OBJECT_IDENTIFIER)((ANY)val).decodeWith(OBJECT_IDENTIFIER.getTemplate());
                                break block23;
                            }
                            throw new InvalidBERException("Content-Type authenticated attribute has unexpected content type");
                        }
                        catch (InvalidBERException e) {
                            throw new SignatureException("Content-Type authenticated attribute does not have OBJECT IDENTIFIER value");
                        }
                    }
                    if (!ctype.equals(contentType)) {
                        throw new SignatureException("Content-type in authenticated attributes does not match content-type being verified");
                    }
                    foundContentType = true;
                    continue;
                }
                if (!attrib.getType().equals(MESSAGE_DIGEST)) continue;
                vals = attrib.getValues();
                if (vals.size() != 1) {
                    throw new SignatureException("Message-digest attribute does not have exactly one value");
                }
                val = vals.elementAt(0);
                try {
                    if (val instanceof OCTET_STRING) {
                        mdigest = ((OCTET_STRING)val).toByteArray();
                        break block24;
                    }
                    if (val instanceof ANY) {
                        OCTET_STRING os = (OCTET_STRING)((ANY)val).decodeWith(OCTET_STRING.getTemplate());
                        mdigest = os.toByteArray();
                        break block24;
                    }
                    throw new InvalidBERException("Content-Type authenticated attribute has unexpected content type");
                }
                catch (InvalidBERException e) {
                    throw new SignatureException("Message-digest attribute does not have OCTET STRING value");
                }
            }
            if (!SignerInfo.byteArraysAreSame(mdigest, messageDigest)) {
                throw new SignatureException("Message-digest attribute does not match message digest being verified");
            }
            foundMessageDigest = true;
        }
        if (!foundContentType) {
            throw new SignatureException("Authenticated attributes does not contain PKCS #9 content-type attribute");
        }
        if (!foundMessageDigest) {
            throw new SignatureException("Authenticate attributes does not contain PKCS #9 message-digest attribute");
        }
        SignatureAlgorithm sigAlg = SignatureAlgorithm.fromOID(this.digestEncryptionAlgorithm.getOID());
        CryptoToken token = CryptoManager.getInstance().getInternalCryptoToken();
        Signature sig = token.getSignatureContext(sigAlg);
        sig.initVerify(pubkey);
        try {
            byte[] encodedAuthAttrib = ASN1Util.encode(this.authenticatedAttributes);
            ANY any = (ANY)ASN1Util.decode(ANY.getTemplate(), encodedAuthAttrib);
            toBeDigested = any.getContents();
        }
        catch (InvalidBERException e) {
            Assert.notReached("Unable to decode authenticated attributes");
            toBeDigested = null;
        }
        MessageDigest md = MessageDigest.getInstance(DigestAlgorithm.fromOID(this.digestAlgorithm.getOID()).toString());
        byte[] digest = md.digest(toBeDigested);
        if (sigAlg.getRawAlg() == SignatureAlgorithm.RSASignature) {
            SEQUENCE digestInfo = new SEQUENCE();
            digestInfo.addElement(this.digestAlgorithm.getOID());
            digestInfo.addElement(new OCTET_STRING(digest));
            toBeVerified = ASN1Util.encode(digestInfo);
        } else {
            toBeVerified = digest;
        }
        sig.update(toBeVerified);
        if (!sig.verify(this.encryptedDigest.toByteArray())) {
            throw new SignatureException("encryptedDigest was not the correct signature of the contents octets of the DER-encoded authenticated attributes");
        }
    }

    private static boolean byteArraysAreSame(byte[] left, byte[] right) {
        Assert._assert(left != null && right != null);
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (left[i] == right[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    @Override
    public void encode(Tag tag, OutputStream ostream) throws IOException {
        SEQUENCE sequence = new SEQUENCE();
        sequence.addElement(this.version);
        sequence.addElement(this.issuerAndSerialNumber);
        sequence.addElement(this.digestAlgorithm);
        if (this.authenticatedAttributes != null) {
            sequence.addElement(new Tag(0L), this.authenticatedAttributes);
        }
        sequence.addElement(this.digestEncryptionAlgorithm);
        sequence.addElement(this.encryptedDigest);
        if (this.unauthenticatedAttributes != null) {
            sequence.addElement(new Tag(1L), this.unauthenticatedAttributes);
        }
        sequence.encode(tag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(IssuerAndSerialNumber.getTemplate());
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addOptionalElement(new Tag(0L), new SET.OF_Template(Attribute.getTemplate()));
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(OCTET_STRING.getTemplate());
            this.seqt.addOptionalElement(new Tag(1L), new SET.OF_Template(Attribute.getTemplate()));
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            Assert._assert(seq.size() == 7);
            return new SignerInfo((INTEGER)seq.elementAt(0), (IssuerAndSerialNumber)seq.elementAt(1), (AlgorithmIdentifier)seq.elementAt(2), (SET)seq.elementAt(3), (AlgorithmIdentifier)seq.elementAt(4), ((OCTET_STRING)seq.elementAt(5)).toByteArray(), (SET)seq.elementAt(6));
        }
    }
}

