/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cert;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.Calendar;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.InvalidKeyFormatException;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.manage.CryptoManager;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;

public class Certificate
implements ASN1Value {
    private CertificateInfo info;
    private byte[] infoEncoding;
    private byte[] signature;
    private AlgorithmIdentifier algId;
    SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private Certificate() {
    }

    Certificate(CertificateInfo info, byte[] infoEncoding, AlgorithmIdentifier algId, byte[] signature) throws IOException {
        this.info = info;
        this.infoEncoding = infoEncoding;
        this.algId = algId;
        this.signature = signature;
        this.sequence = new SEQUENCE();
        this.sequence.addElement(info);
        this.sequence.addElement(algId);
        this.sequence.addElement(new BIT_STRING(signature, 0));
    }

    public Certificate(CertificateInfo info, PrivateKey privKey, SignatureAlgorithm signingAlg) throws IOException, CryptoManager.NotInitializedException, TokenException, NoSuchAlgorithmException, CertificateException, InvalidKeyException, SignatureException {
        if (!(privKey instanceof org.mozilla.jss.crypto.PrivateKey)) {
            throw new InvalidKeyException("Private Key is does not belong to this provider");
        }
        org.mozilla.jss.crypto.PrivateKey priv = (org.mozilla.jss.crypto.PrivateKey)privKey;
        this.algId = signingAlg.getSigningAlg() == SignatureAlgorithm.RSASignature ? new AlgorithmIdentifier(signingAlg.toOID(), null) : new AlgorithmIdentifier(signingAlg.toOID());
        if (!info.getSignatureAlgId().getOID().equals(this.algId.getOID())) {
            throw new CertificateException("Signing Algorithm does not match the one specified in the CertificateInfo");
        }
        this.info = info;
        this.infoEncoding = ASN1Util.encode(info);
        CryptoManager cm = CryptoManager.getInstance();
        CryptoToken token = priv.getOwningToken();
        Signature sig = token.getSignatureContext(signingAlg);
        sig.initSign(priv);
        sig.update(this.infoEncoding);
        this.signature = sig.sign();
        this.sequence = new SEQUENCE();
        this.sequence.addElement(info);
        this.sequence.addElement(this.algId);
        this.sequence.addElement(new BIT_STRING(this.signature, 0));
    }

    public void verify() throws InvalidKeyException, CryptoManager.NotInitializedException, NoSuchAlgorithmException, CertificateException, TokenException, SignatureException, InvalidKeyFormatException {
        this.verify(this.info.getSubjectPublicKeyInfo().toPublicKey());
    }

    public void verify(PublicKey key) throws InvalidKeyException, CryptoManager.NotInitializedException, NoSuchAlgorithmException, CertificateException, TokenException, SignatureException {
        CryptoManager cm = CryptoManager.getInstance();
        this.verify(key, cm.getInternalCryptoToken());
    }

    public void verify(PublicKey key, CryptoToken token) throws NoSuchAlgorithmException, CertificateException, TokenException, SignatureException, InvalidKeyException {
        Signature sig = token.getSignatureContext(SignatureAlgorithm.fromOID(this.info.getSignatureAlgId().getOID()));
        sig.initVerify(key);
        sig.update(this.infoEncoding);
        if (!sig.verify(this.signature)) {
            throw new CertificateException("Signature is invalid");
        }
    }

    public CertificateInfo getInfo() {
        return this.info;
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public byte[] getInfoEncoding() {
        return this.infoEncoding;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encode(baos);
        return baos.toByteArray();
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static void main(String[] argv) {
        try {
            if (argv.length > 2 || argv.length < 1) {
                System.out.println("Usage: Certificate <dbdir> [<certfile>]");
                System.exit(0);
            }
            CryptoManager.initialize(argv[0]);
            CryptoManager cm = CryptoManager.getInstance();
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(argv[1]));
            Certificate cert = (Certificate)Certificate.getTemplate().decode(bis);
            CertificateInfo info = cert.getInfo();
            info.print(System.out);
            cert.verify();
            System.out.println("verified");
            FileOutputStream fos = new FileOutputStream("certinfo.der");
            info.encode(fos);
            fos.close();
            CryptoToken token = cm.getInternalKeyStorageToken();
            KeyPairGenerator kpg = token.getKeyPairGenerator(KeyPairAlgorithm.RSA);
            kpg.initialize(512);
            System.out.println("Generating a new key pair...");
            KeyPair kp = kpg.genKeyPair();
            System.out.println("Generated key pair");
            info.setSubjectPublicKeyInfo(kp.getPublic());
            int newSerial = info.getSerialNumber().intValue() + 1;
            info.setSerialNumber(new INTEGER(newSerial));
            Name name = new Name();
            name.addCommonName("Stra\u00dfenverk\u00e4ufer 'R' Us");
            name.addCountryName("US");
            name.addOrganizationName("Some Corporation");
            name.addOrganizationalUnitName("some org unit?");
            name.addLocalityName("Silicon Valley");
            name.addStateOrProvinceName("California");
            info.setIssuer(name);
            info.setSubject(name);
            Calendar cal = Calendar.getInstance();
            cal.set(1997, 3, 1);
            info.setNotBefore(cal.getTime());
            cal.set(2010, 3, 1);
            info.setNotAfter(cal.getTime());
            System.out.println("About to create a new cert...");
            Certificate genCert = new Certificate(info, kp.getPrivate(), SignatureAlgorithm.RSASignatureWithMD5Digest);
            System.out.println("Created new cert");
            genCert.verify();
            System.out.println("Cert verifies!");
            fos = new FileOutputStream("gencert.der");
            genCert.encode(fos);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(new ANY.Template());
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(BIT_STRING.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            ANY infoAny = (ANY)seq.elementAt(0);
            byte[] infoEncoding = infoAny.getEncoded();
            CertificateInfo info = (CertificateInfo)infoAny.decodeWith(CertificateInfo.getTemplate());
            BIT_STRING bs = (BIT_STRING)seq.elementAt(2);
            if (bs.getPadCount() != 0) {
                throw new InvalidBERException("signature does not fall into an integral number of bytes");
            }
            byte[] signature = bs.getBits();
            return new Certificate(info, infoEncoding, (AlgorithmIdentifier)seq.elementAt(1), signature);
        }
    }
}

