/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class Extension
implements ASN1Value {
    public static final Tag TAG = SEQUENCE.TAG;
    private OBJECT_IDENTIFIER extnId;
    private boolean critical;
    private OCTET_STRING extnValue;
    private static final Template templateInstance = new Template();

    @Override
    public Tag getTag() {
        return TAG;
    }

    public OBJECT_IDENTIFIER getExtnId() {
        return this.extnId;
    }

    public boolean getCritical() {
        return this.critical;
    }

    public OCTET_STRING getExtnValue() {
        return this.extnValue;
    }

    private Extension() {
    }

    public Extension(OBJECT_IDENTIFIER extnId, boolean critical, OCTET_STRING extnValue) {
        this.extnId = extnId;
        this.critical = critical;
        this.extnValue = extnValue;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    @Override
    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement(this.extnId);
        if (this.critical) {
            seq.addElement(new BOOLEAN(true));
        }
        seq.addElement(this.extnValue);
        seq.encode(implicit, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addElement(BOOLEAN.getTemplate(), new BOOLEAN(false));
            this.seqt.addElement(OCTET_STRING.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag t) {
            return TAG.equals(t);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            return new Extension((OBJECT_IDENTIFIER)seq.elementAt(0), ((BOOLEAN)seq.elementAt(1)).toBoolean(), (OCTET_STRING)seq.elementAt(2));
        }
    }
}

