/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cert;

import java.io.IOException;
import java.io.InputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cert.Extension;
import org.mozilla.jss.util.Assert;

public class SubjectKeyIdentifier
extends Extension {
    private OCTET_STRING keyIdentifier;
    private static OBJECT_IDENTIFIER OID = new OBJECT_IDENTIFIER("2.5.29.14");

    public SubjectKeyIdentifier(OCTET_STRING keyIdentifier) {
        super(OID, false, keyIdentifier);
    }

    public SubjectKeyIdentifier(boolean critical, OCTET_STRING keyIdentifier) {
        super(OID, critical, keyIdentifier);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addElement(BOOLEAN.getTemplate(), new BOOLEAN(false));
            this.seqt.addElement(OCTET_STRING.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag t) {
            return Extension.TAG.equals(t);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(Extension.TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            Assert._assert(((OBJECT_IDENTIFIER)seq.elementAt(0)).equals(OID));
            return new SubjectKeyIdentifier(((BOOLEAN)seq.elementAt(1)).toBoolean(), (OCTET_STRING)seq.elementAt(2));
        }
    }
}

