/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import org.mozilla.jss.pkix.primitive.Name;

public class DafName
extends Name {
    private String[] itsCommonName = null;
    private String[] itsDistinguishedName = null;
    private String[] itsOrganizationalUnitName = null;
    private String itsOrganizationName = null;
    private String itsCountryName = null;

    public DafName() {
    }

    public DafName(Name n) throws Exception {
        for (int i = 0; i < n.size(); ++i) {
            String s = new String(n.elementAt(i).at(0).getValue().getContents());
            if (n.elementAt(i).at(0).getOID().equals(Name.commonName)) {
                this.addCommonName(s);
                continue;
            }
            if (n.elementAt(i).at(0).getOID().equals(Name.countryName)) {
                this.addCountryName(s);
                continue;
            }
            if (n.elementAt(i).at(0).getOID().equals(Name.organizationalUnitName)) {
                this.addOrganizationalUnitName(s);
                continue;
            }
            if (n.elementAt(i).at(0).getOID().equals(Name.organizationName)) {
                this.addOrganizationName(s);
                continue;
            }
            if (n.elementAt(i).at(0).getOID().equals(Name.distinguishedNameQualifier)) {
                this.addOrganizationName(s);
                continue;
            }
            System.out.println("unknown OID " + n.elementAt(i).at(0).getOID());
        }
    }

    @Override
    public void addCommonName(String s) {
        try {
            super.addCommonName(s);
            if (this.itsCommonName == null) {
                this.itsCommonName = new String[1];
                this.itsCommonName[0] = s;
            } else {
                String[] dummy = new String[this.itsCommonName.length + 1];
                for (int i = 0; i < this.itsCommonName.length; ++i) {
                    dummy[i] = this.itsCommonName[i];
                }
                dummy[this.itsCommonName.length] = s;
                this.itsCommonName = dummy;
            }
        }
        catch (CharConversionException cce) {
            System.out.println("error: " + cce);
        }
    }

    public void addCommonName(String[] ss) {
        for (int i = 0; i < ss.length; ++i) {
            this.addCommonName(ss[i]);
        }
    }

    @Override
    public void addDistinguishedName(String s) {
        try {
            super.addDistinguishedName(s);
            if (this.itsDistinguishedName == null) {
                this.itsDistinguishedName = new String[1];
                this.itsDistinguishedName[0] = s;
            } else {
                String[] dummy = new String[this.itsDistinguishedName.length + 1];
                for (int i = 0; i < this.itsDistinguishedName.length; ++i) {
                    dummy[i] = this.itsDistinguishedName[i];
                }
                dummy[this.itsDistinguishedName.length] = s;
                this.itsDistinguishedName = dummy;
            }
        }
        catch (CharConversionException cce) {
            System.out.println("error: " + cce);
        }
    }

    public void addDistinguishedName(String[] ss) {
        for (int i = 0; i < ss.length; ++i) {
            this.addDistinguishedName(ss[i]);
        }
    }

    @Override
    public void addOrganizationalUnitName(String s) {
        try {
            super.addOrganizationalUnitName(s);
            if (this.itsOrganizationalUnitName == null) {
                this.itsOrganizationalUnitName = new String[1];
                this.itsOrganizationalUnitName[0] = s;
            } else {
                String[] dummy = new String[this.itsOrganizationalUnitName.length + 1];
                for (int i = 0; i < this.itsOrganizationalUnitName.length; ++i) {
                    dummy[i] = this.itsOrganizationalUnitName[i];
                }
                dummy[this.itsOrganizationalUnitName.length] = s;
                this.itsOrganizationalUnitName = dummy;
            }
        }
        catch (CharConversionException cce) {
            System.out.println("error: " + cce);
        }
    }

    public void addOrganizationalUnitName(String[] ss) {
        if (ss != null) {
            for (int i = 0; i < ss.length; ++i) {
                this.addOrganizationalUnitName(ss[i]);
            }
        }
    }

    @Override
    public void addOrganizationName(String s) {
        try {
            super.addOrganizationName(s);
            this.itsOrganizationName = s;
        }
        catch (CharConversionException cce) {
            System.out.println("error: " + cce);
        }
    }

    @Override
    public void addCountryName(String s) {
        try {
            super.addCountryName(s);
            this.itsCountryName = s;
        }
        catch (CharConversionException cce) {
            System.out.println("error: " + cce);
        }
    }

    public String getCountryName() {
        return this.itsCountryName;
    }

    public String getOrganizationName() {
        return this.itsOrganizationName;
    }

    public String[] getOrganizationalUnitName() {
        return this.itsOrganizationalUnitName;
    }

    public String[] getCommonName() {
        return this.itsCommonName;
    }

    public String[] getDistinguishedName() {
        return this.itsDistinguishedName;
    }

    @Override
    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.encode(baos);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            System.out.println("IO: " + ioe);
            return null;
        }
    }

    public String stripColons(String mac) {
        String maca = mac;
        int idx = maca.indexOf(58);
        while (idx != -1) {
            maca = maca.substring(0, idx) + maca.substring(idx + 1, maca.length());
            idx = maca.indexOf(58);
        }
        return maca;
    }

    public static void main(String[] args) {
        try {
            Name n = new Name();
            n.addCommonName("01:02:03:04:05:06");
            n.addOrganizationalUnitName("Euro-PacketCable");
            n.addOrganizationalUnitName("org2");
            n.addOrganizationName("tComLabs, Belgium");
            n.addCountryName("BE");
            n.addDistinguishedName("CASID:12345");
            DafName dn = new DafName(n);
            System.out.println("commonname: " + dn.stripColons(dn.getCommonName()[0]));
            System.out.println("dafname: " + dn.getRFC1485());
        }
        catch (Exception e) {
            System.out.println("exception: " + e);
        }
    }
}

