/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.PrintableString;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AVA;
import org.mozilla.jss.pkix.primitive.DirectoryString;
import org.mozilla.jss.pkix.primitive.RDN;

public class Name
implements ASN1Value {
    SEQUENCE rdns;
    public static final Tag TAG = SEQUENCE.TAG;
    public static final OBJECT_IDENTIFIER commonName = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 4L, 3L});
    public static final OBJECT_IDENTIFIER serialNumber = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 4L, 5L});
    public static final OBJECT_IDENTIFIER countryName = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 4L, 6L});
    public static final OBJECT_IDENTIFIER localityName = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 4L, 7L});
    public static final OBJECT_IDENTIFIER stateOrProvinceName = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 4L, 8L});
    public static final OBJECT_IDENTIFIER organizationName = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 4L, 10L});
    public static final OBJECT_IDENTIFIER organizationalUnitName = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 4L, 11L});
    public static final OBJECT_IDENTIFIER distinguishedNameQualifier = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 4L, 46L});
    private static final Template templateInstance = new Template();

    public Name() {
        this.rdns = new SEQUENCE();
    }

    Name(SEQUENCE rdns) {
        this.rdns = rdns;
    }

    public void addElement(RDN name) {
        this.rdns.addElement(name);
    }

    public void addElement(AVA ava) {
        this.rdns.addElement(new RDN(ava));
    }

    public void insertElementAt(RDN name, int idx) {
        this.rdns.insertElementAt(name, idx);
    }

    public RDN elementAt(int idx) {
        return (RDN)this.rdns.elementAt(idx);
    }

    public void removeElementAt(int idx) {
        this.rdns.removeElementAt(idx);
    }

    public int size() {
        return this.rdns.size();
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.rdns.encode(ostream);
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encode(baos);
        return baos.toByteArray();
    }

    @Override
    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.rdns.encode(implicit, ostream);
    }

    public void addCommonName(String CN) throws CharConversionException {
        this.addElement(new AVA(commonName, new DirectoryString(CN)));
    }

    public void addDistinguishedName(String DN) throws CharConversionException {
        this.addElement(new AVA(distinguishedNameQualifier, new PrintableString(DN)));
    }

    public void addSerialNumber(String SN) throws CharConversionException {
        this.addElement(new AVA(serialNumber, new PrintableString(SN)));
    }

    public void addCountryName(String C) throws CharConversionException {
        if (C.length() != 2) {
            throw new IllegalArgumentException("Country name must be exactly 2 characters");
        }
        this.addElement(new AVA(countryName, new DirectoryString(C)));
    }

    public void addLocalityName(String L) throws CharConversionException {
        this.addElement(new AVA(localityName, new DirectoryString(L)));
    }

    public void addStateOrProvinceName(String S) throws CharConversionException {
        this.addElement(new AVA(stateOrProvinceName, new DirectoryString(S)));
    }

    public void addOrganizationName(String O) throws CharConversionException {
        this.addElement(new AVA(organizationName, new DirectoryString(O)));
    }

    public void addOrganizationalUnitName(String OU) throws CharConversionException {
        this.addElement(new AVA(organizationalUnitName, new DirectoryString(OU)));
    }

    private String typeToString(OBJECT_IDENTIFIER type) {
        if (type.equals(commonName)) {
            return "CN";
        }
        if (type.equals(countryName)) {
            return "C";
        }
        if (type.equals(localityName)) {
            return "L";
        }
        if (type.equals(stateOrProvinceName)) {
            return "S";
        }
        if (type.equals(organizationName)) {
            return "O";
        }
        if (type.equals(organizationalUnitName)) {
            return "OU";
        }
        return null;
    }

    private String AVAToString(AVA ava) throws InvalidBERException {
        OBJECT_IDENTIFIER oid = ava.getOID();
        String type = this.typeToString(oid);
        if (type == null) {
            return "";
        }
        return type + "=" + (DirectoryString)ava.getValue().decodeWith(DirectoryString.getTemplate());
    }

    public String getRFC1485() throws InvalidBERException {
        StringBuffer buf = new StringBuffer(80);
        for (int r = 0; r < this.rdns.size(); ++r) {
            if (r > 0) {
                buf.append(", ");
            }
            buf.append(this.AVAToString(((RDN)this.rdns.elementAt(r)).at(0)));
        }
        return buf.toString();
    }

    public boolean equals(Name othername) throws Exception {
        return this.getRFC1485().equals(othername.getRFC1485());
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                Name name = new Name();
                OBJECT_IDENTIFIER oid = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 4L, 10L});
                AVA ava = new AVA(oid, new PrintableString("Netscape"));
                name.addElement(ava);
                oid = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 4L, 3L});
                ava = new AVA(oid, new PrintableString("moi"));
                name.addElement(ava);
                name.encode(System.out);
            } else {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(args[0]));
                Template temp = new Template();
                Name name = (Name)temp.decode(bis);
                System.out.println("Got name.");
                for (int i = 0; i < name.size(); ++i) {
                    AVA a = name.elementAt(i).at(0);
                    PrintableString.Template pst = new PrintableString.Template();
                    PrintableString ps = (PrintableString)pst.decode(new ByteArrayInputStream(a.getValue().getEncoded()));
                    System.out.println("OID: " + a.getOID() + ", String: " + ps);
                }
                System.out.println("End of name");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Template
    implements ASN1Template {
        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.OF_Template seqt = new SEQUENCE.OF_Template(new RDN.Template());
            SEQUENCE seq = (SEQUENCE)seqt.decode(implicit, istream);
            return new Name(seq);
        }
    }
}

