/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Attribute;

public class PrivateKeyInfo
implements ASN1Value,
PrivateKey {
    private INTEGER version;
    private AlgorithmIdentifier privateKeyAlgorithm;
    private OCTET_STRING privateKey;
    private SET attributes;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public INTEGER getVersion() {
        return this.version;
    }

    public AlgorithmIdentifier getPrivateKeyAlgorithm() {
        return this.privateKeyAlgorithm;
    }

    @Override
    public String getAlgorithm() {
        try {
            return PrivateKey.Type.fromOID(this.privateKeyAlgorithm.getOID()).toString();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return this.privateKey.toByteArray();
    }

    public OCTET_STRING getPrivateKey() {
        return this.privateKey;
    }

    public SET getAttributes() {
        return this.attributes;
    }

    private PrivateKeyInfo() {
    }

    public PrivateKeyInfo(INTEGER version, AlgorithmIdentifier privateKeyAlgorithm, OCTET_STRING privateKey, SET attributes) {
        if (version == null || privateKeyAlgorithm == null || privateKey == null) {
            throw new IllegalArgumentException("PrivateKeyInfo parameter is null");
        }
        this.version = version;
        this.privateKeyAlgorithm = privateKeyAlgorithm;
        this.privateKey = privateKey;
        this.attributes = attributes;
        this.sequence = new SEQUENCE();
        this.sequence.addElement(version);
        this.sequence.addElement(privateKeyAlgorithm);
        this.sequence.addElement(privateKey);
        if (attributes != null) {
            this.sequence.addElement(new Tag(0L), attributes);
            int size = attributes.size();
            for (int i = 0; i < size; ++i) {
                if (attributes.elementAt(i) instanceof Attribute) continue;
                throw new IllegalArgumentException("element " + i + " of attributes is not an Attribute");
            }
        }
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(OCTET_STRING.getTemplate());
            this.seqt.addOptionalElement(new Tag(0L), new SET.OF_Template(Attribute.getTemplate()));
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new PrivateKeyInfo((INTEGER)seq.elementAt(0), (AlgorithmIdentifier)seq.elementAt(1), (OCTET_STRING)seq.elementAt(2), (SET)seq.elementAt(3));
        }
    }
}

