/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AVA;
import org.mozilla.jss.pkix.primitive.TooFewElementsException;

public class RDN
implements ASN1Value {
    private SET avas;
    public static final Tag TAG = SET.TAG;

    private RDN() {
    }

    public RDN(AVA initialElement) {
        this.avas = new SET();
        this.avas.addElement(initialElement);
    }

    RDN(SET avas) {
        this.avas = avas;
    }

    public void add(AVA ava) {
        this.avas.addElement(ava);
    }

    public AVA at(int idx) {
        return (AVA)this.avas.elementAt(idx);
    }

    public void removeAt(int idx) throws TooFewElementsException {
        if (this.avas.size() <= 1) {
            throw new TooFewElementsException();
        }
        this.avas.removeElementAt(idx);
    }

    public int size() {
        return this.avas.size();
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.avas.encode(ostream);
    }

    @Override
    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.avas.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            AVA.Template avatemp = new AVA.Template();
            SET.OF_Template sett = new SET.OF_Template(avatemp);
            SET set = (SET)sett.decode(implicit, istream);
            if (set.size() < 1) {
                throw new InvalidBERException("RDN with zero elements; an RDN must have at least one element");
            }
            return new RDN(set);
        }
    }
}

