/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.InvalidKeyFormatException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.util.Assert;

public class SubjectPublicKeyInfo
implements ASN1Value,
PublicKey {
    private AlgorithmIdentifier algorithm;
    private BIT_STRING subjectPublicKey;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    @Override
    public String getAlgorithm() {
        try {
            return PrivateKey.Type.fromOID(this.algorithm.getOID()).toString();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        if (this.subjectPublicKey.getPadCount() != 0) {
            Assert.notReached("public key is not an integral number of bytes");
            return null;
        }
        return this.subjectPublicKey.getBits();
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithm;
    }

    public BIT_STRING getSubjectPublicKey() {
        return this.subjectPublicKey;
    }

    private SubjectPublicKeyInfo() {
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier algorithm, BIT_STRING subjectPublicKey) {
        this.algorithm = algorithm;
        this.subjectPublicKey = subjectPublicKey;
    }

    public SubjectPublicKeyInfo(PublicKey pubk) throws InvalidBERException, IOException {
        SubjectPublicKeyInfo spki = (SubjectPublicKeyInfo)ASN1Util.decode(SubjectPublicKeyInfo.getTemplate(), pubk.getEncoded());
        this.algorithm = spki.algorithm;
        this.subjectPublicKey = spki.subjectPublicKey;
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    @Override
    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement(this.algorithm);
        seq.addElement(this.subjectPublicKey);
        seq.encode(implicit, ostream);
    }

    public byte[] getEnc() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encode(baos);
        return baos.toByteArray();
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public PublicKey toPublicKey() throws NoSuchAlgorithmException, InvalidKeyFormatException {
        PrivateKey.Type type = PrivateKey.Type.fromOID(this.algorithm.getOID());
        if (this.subjectPublicKey.getPadCount() != 0) {
            throw new InvalidKeyFormatException();
        }
        return PK11PubKey.fromRaw(type, this.subjectPublicKey.getBits());
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(BIT_STRING.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            return new SubjectPublicKeyInfo((AlgorithmIdentifier)seq.elementAt(0), (BIT_STRING)seq.elementAt(1));
        }
    }
}

