/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider;

import java.security.DigestException;
import java.security.NoSuchAlgorithmException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.JSSMessageDigest;
import org.mozilla.jss.crypto.TokenSupplierManager;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.Debug;

abstract class MessageDigest
extends java.security.MessageDigest {
    private JSSMessageDigest md;

    protected abstract DigestAlgorithm getAlg();

    protected MessageDigest(String algName) {
        super(algName);
        try {
            Debug.trace(10, "In JSS JCA message digest constructor");
            CryptoToken internal = TokenSupplierManager.getTokenSupplier().getInternalCryptoToken();
            this.md = internal.getDigestContext(this.getAlg());
        }
        catch (NoSuchAlgorithmException e) {
            Debug.trace(1, "Unknown message digesting algorithm: " + algName);
            Assert.notReached("Unknown message digesting algorithm");
        }
        catch (DigestException e) {
            Debug.trace(1, "Digest Exception while creating " + algName + " digest");
            Assert.notReached("Digest exception creating message digest");
        }
    }

    @Override
    protected void engineUpdate(byte input) {
        try {
            Debug.trace(10, "In JSS JCA message digest engineUpdate");
            this.md.update(input);
        }
        catch (DigestException e) {
            Debug.trace(1, "Digest Exception while updating digest");
            Assert.notReached("Digest exception while updating digest");
        }
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        try {
            Debug.trace(10, "In JSS JCA message digest engineUpdate");
            this.md.update(input, offset, len);
        }
        catch (DigestException e) {
            Debug.trace(1, "Digest Exception while updating digest");
            Assert.notReached("Digest exception while updating digest");
        }
    }

    @Override
    protected byte[] engineDigest() {
        try {
            Debug.trace(10, "In JSS JCA message digest engineDigest");
            return this.md.digest();
        }
        catch (DigestException e) {
            Debug.trace(1, "Digest Exception while finalizing digest");
            Assert.notReached("Digest exception while finalizing digest");
            return null;
        }
    }

    @Override
    protected void engineReset() {
        try {
            Debug.trace(10, "In JSS JCA message digest engineReset");
            this.md.reset();
        }
        catch (DigestException e) {
            Debug.trace(1, "Digest Exception while resetting digest");
            Assert.notReached("Digest exception while resetting digest");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

