/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenSupplierManager;

public class Signature {
    org.mozilla.jss.crypto.Signature sig;

    public void engineInitSign(PrivateKey privateKey, SecureRandom random, SignatureAlgorithm sigAlg) throws InvalidKeyException {
        this.engineInitSign(privateKey, sigAlg);
    }

    public void engineInitSign(PrivateKey privateKey, SignatureAlgorithm sigAlg) throws InvalidKeyException {
        try {
            this.sig = Signature.getSigContext(privateKey, sigAlg);
            this.sig.initSign((org.mozilla.jss.crypto.PrivateKey)privateKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException("Algorithm not supported");
        }
        catch (TokenException e) {
            throw new InvalidKeyException("Token exception occurred");
        }
    }

    protected static org.mozilla.jss.crypto.Signature getSigContext(PrivateKey privateKey, SignatureAlgorithm sigAlg) throws NoSuchAlgorithmException, InvalidKeyException, TokenException {
        if (!(privateKey instanceof org.mozilla.jss.crypto.PrivateKey)) {
            throw new InvalidKeyException();
        }
        org.mozilla.jss.crypto.PrivateKey privk = (org.mozilla.jss.crypto.PrivateKey)privateKey;
        CryptoToken token = privk.getOwningToken();
        return token.getSignatureContext(sigAlg);
    }

    public void engineInitVerify(PublicKey publicKey, SignatureAlgorithm sigAlg) throws InvalidKeyException {
        try {
            CryptoToken token = TokenSupplierManager.getTokenSupplier().getInternalCryptoToken();
            this.sig = token.getSignatureContext(sigAlg);
            this.sig.initVerify(publicKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException("Algorithm not supported");
        }
        catch (TokenException e) {
            throw new InvalidKeyException("Token exception occurred");
        }
    }

    public void engineUpdate(byte b) throws SignatureException {
        try {
            this.sig.update(b);
        }
        catch (TokenException e) {
            throw new SignatureException("TokenException: " + e.toString());
        }
    }

    public void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        try {
            this.sig.update(b, off, len);
        }
        catch (TokenException e) {
            throw new SignatureException("TokenException: " + e.toString());
        }
    }

    public byte[] engineSign() throws SignatureException {
        try {
            return this.sig.sign();
        }
        catch (TokenException e) {
            throw new SignatureException("TokenException: " + e.toString());
        }
    }

    public int engineSign(byte[] outbuf, int offset, int len) throws SignatureException {
        try {
            return this.sig.sign(outbuf, offset, len);
        }
        catch (TokenException e) {
            throw new SignatureException("TokenException: " + e.toString());
        }
    }

    public boolean engineVerify(byte[] sigBytes) throws SignatureException {
        try {
            return this.sig.verify(sigBytes);
        }
        catch (TokenException e) {
            throw new SignatureException("TokenException: " + e.toString());
        }
    }

    public void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        try {
            this.sig.setParameter(params);
        }
        catch (TokenException e) {
            throw new InvalidAlgorithmParameterException("TokenException: " + e.toString());
        }
    }
}

