/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.Debug;

public abstract class NativeProxy {
    private byte[] mPointer;
    private long registryIndex;
    static Hashtable registry = new Hashtable();
    static Random indexGenerator = new Random();

    private NativeProxy() {
        Assert._assert(false);
    }

    public NativeProxy(byte[] pointer) {
        Assert._assert(pointer != null);
        this.registryIndex = NativeProxy.register();
        this.mPointer = pointer;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NativeProxy)) {
            return false;
        }
        if (((NativeProxy)obj).mPointer.length != this.mPointer.length) {
            return false;
        }
        for (int i = 0; i < this.mPointer.length; ++i) {
            if (this.mPointer[i] == ((NativeProxy)obj).mPointer[i]) continue;
            return false;
        }
        return true;
    }

    protected abstract void releaseNativeResources();

    protected void finalize() throws Throwable {
        NativeProxy.unregister(this.registryIndex);
        this.releaseNativeResources();
    }

    private static synchronized long register() {
        Long index;
        while (registry.containsKey(index = new Long(indexGenerator.nextLong()))) {
        }
        registry.put(index, index);
        return index;
    }

    private static synchronized void unregister(long index) {
        Long Lindex = new Long(index);
        Long element = (Long)registry.remove(Lindex);
        Assert._assert(element != null);
    }

    public static synchronized Enumeration getRegistryIndices() {
        return registry.keys();
    }

    public long getRegistryIndex() {
        return this.registryIndex;
    }

    public static synchronized void assertRegistryEmpty() {
        if (!registry.isEmpty()) {
            Debug.trace(5, "Warning: " + String.valueOf(registry.size()) + " NativeProxys are still registered.");
        } else {
            Debug.trace(10, "NativeProxy registry is empty");
        }
    }
}

