/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.util;

import java.io.CharConversionException;
import java.io.Serializable;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.PasswordCallback;
import org.mozilla.jss.util.PasswordCallbackInfo;
import org.mozilla.jss.util.UTF8Converter;

public class Password
implements PasswordCallback,
Cloneable,
Serializable {
    private char[] password;
    private boolean cleared;

    private Password() {
        this.cleared = true;
    }

    public Password(char[] pw) {
        int length = pw.length;
        this.cleared = false;
        this.password = new char[length];
        for (int i = 0; i < length; ++i) {
            this.password[i] = pw[i];
            pw[i] = '\u0000';
        }
    }

    @Override
    public synchronized Password getPasswordFirstAttempt(PasswordCallbackInfo info) throws PasswordCallback.GiveUpException {
        if (this.cleared) {
            throw new PasswordCallback.GiveUpException();
        }
        return (Password)this.clone();
    }

    public synchronized boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Password)) {
            return false;
        }
        Password pw = (Password)obj;
        if (pw.password == null || this.password == null) {
            return false;
        }
        if (pw.password.length != this.password.length) {
            return false;
        }
        for (int i = 0; i < this.password.length; ++i) {
            if (pw.password[i] == this.password[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized Password getPasswordAgain(PasswordCallbackInfo info) throws PasswordCallback.GiveUpException {
        throw new PasswordCallback.GiveUpException();
    }

    public synchronized char[] getChars() {
        return this.password;
    }

    public synchronized char[] getCharCopy() {
        return (char[])this.password.clone();
    }

    synchronized byte[] getByteCopy() {
        return Password.charToByte((char[])this.password.clone());
    }

    public synchronized void clear() {
        int len = this.password.length;
        for (int i = 0; i < len; ++i) {
            this.password[i] = '\u0000';
        }
        this.cleared = true;
    }

    public synchronized Object clone() {
        Password dolly = new Password();
        dolly.password = (char[])this.password.clone();
        dolly.cleared = this.cleared;
        return dolly;
    }

    protected void finalize() throws Throwable {
        if (!this.cleared) {
            System.err.println("ERROR: Password was garbage collected before it was cleared.");
        }
        this.clear();
    }

    public static byte[] charToByte(char[] charArray) {
        byte[] byteArray;
        Assert._assert(charArray != null);
        try {
            byteArray = UTF8Converter.UnicodeToUTF8NullTerm(charArray);
        }
        catch (CharConversionException e) {
            Assert.notReached("Password could not be converted from Unicode");
            byteArray = new byte[]{0};
        }
        finally {
            Password.wipeChars(charArray);
        }
        return byteArray;
    }

    public static void wipeBytes(byte[] byteArray) {
        Assert._assert(byteArray != null);
        UTF8Converter.wipeBytes(byteArray);
    }

    public static void wipeChars(char[] charArray) {
        Assert._assert(charArray != null);
        for (int i = 0; i < charArray.length; ++i) {
            charArray[i] = '\u0000';
        }
    }

    public static synchronized native Password readPasswordFromConsole() throws PasswordCallback.GiveUpException;
}

