/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.util;

import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.Debug;

public class UTF8Converter {
    public static byte[] UnicodeToUTF8(char[] unicode) throws CharConversionException {
        return UTF8Converter.UnicodeToUTF8(unicode, false);
    }

    public static byte[] UnicodeToUTF8NullTerm(char[] unicode) throws CharConversionException {
        return UTF8Converter.UnicodeToUTF8(unicode, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static byte[] UnicodeToUTF8(char[] unicode, boolean nullTerminate) throws CharConversionException {
        byte[] byArray;
        int ucs4;
        char c;
        boolean orphaned_low;
        byte[] utf8;
        block39: {
            utf8 = null;
            byte[] temp = null;
            boolean failed = true;
            orphaned_low = false;
            Assert._assert(unicode != null);
            if (unicode == null) {
                return null;
            }
            try {
                int maxsize = unicode.length * 3;
                if (nullTerminate) {
                    ++maxsize;
                }
                utf8 = new byte[maxsize];
                int utf = 0;
                for (int uni = 0; uni < unicode.length; ++uni) {
                    c = unicode[uni];
                    if (c >= '\ud800' && c <= '\udbff') {
                        ucs4 = c - 55296 << 10;
                        if (uni == unicode.length - 1) {
                            throw new CharConversionException();
                        }
                        if ((c = unicode[++uni]) < '\udc00') throw new CharConversionException();
                        if (c > '\udfff') {
                            throw new CharConversionException();
                        }
                        ucs4 |= c - 56320;
                        ucs4 += 65536;
                    } else {
                        if (c >= '\udc00' && c <= '\udfff') {
                            orphaned_low = true;
                            throw new CharConversionException();
                        }
                        ucs4 = unicode[uni];
                    }
                    if (ucs4 < 128) {
                        utf8[utf++] = (byte)ucs4;
                        continue;
                    }
                    if (ucs4 < 2048) {
                        utf8[utf++] = (byte)(0xC0 | ucs4 >> 6);
                        utf8[utf++] = (byte)(0x80 | ucs4 & 0x3F);
                        continue;
                    }
                    if (ucs4 < 65536) {
                        utf8[utf++] = (byte)(0xE0 | ucs4 >> 12);
                        utf8[utf++] = (byte)(0x80 | ucs4 >> 6 & 0x3F);
                        utf8[utf++] = (byte)(0x80 | ucs4 & 0x3F);
                        continue;
                    }
                    if (ucs4 < 0x200000) {
                        utf8[utf++] = (byte)(0xF0 | ucs4 >> 18);
                        utf8[utf++] = (byte)(0x80 | ucs4 >> 12 & 0x3F);
                        utf8[utf++] = (byte)(0x80 | ucs4 >> 6 & 0x3F);
                        utf8[utf++] = (byte)(0x80 | ucs4 & 0x3F);
                        continue;
                    }
                    if (ucs4 < 0x200000) {
                        utf8[utf++] = (byte)(0xF8 | ucs4 >> 24);
                        utf8[utf++] = (byte)(0x80 | ucs4 >> 18 & 0x3F);
                        utf8[utf++] = (byte)(0x80 | ucs4 >> 12 & 0x3F);
                        utf8[utf++] = (byte)(0x80 | ucs4 >> 6 & 0x3F);
                        utf8[utf++] = (byte)(0x80 | ucs4 & 0x3F);
                        continue;
                    }
                    utf8[utf++] = (byte)(0xFC | ucs4 >> 30);
                    utf8[utf++] = (byte)(0x80 | ucs4 >> 24 & 0x3F);
                    utf8[utf++] = (byte)(0x80 | ucs4 >> 18 & 0x3F);
                    utf8[utf++] = (byte)(0x80 | ucs4 >> 12 & 0x3F);
                    utf8[utf++] = (byte)(0x80 | ucs4 >> 6 & 0x3F);
                    utf8[utf++] = (byte)(0x80 | ucs4 & 0x3F);
                }
                if (nullTerminate) {
                    utf8[utf++] = 0;
                }
                try {
                    temp = new byte[utf];
                    for (int i = 0; i < utf; ++i) {
                        temp[i] = utf8[i];
                        utf8[i] = 0;
                    }
                    utf8 = temp;
                    temp = null;
                }
                finally {
                    if (temp != null) {
                        UTF8Converter.wipeBytes(temp);
                    }
                }
                failed = false;
                byArray = utf8;
                if (!failed || utf8 == null) break block39;
            }
            catch (Throwable throwable) {
                if (failed && utf8 != null) {
                    UTF8Converter.wipeBytes(utf8);
                    utf8 = null;
                }
                boolean ucs42 = false;
                boolean c2 = false;
                try {
                    ByteArrayOutputStream barray = new ByteArrayOutputStream();
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)barray, "UTF8");
                    writer.write(unicode, 0, unicode.length);
                    writer.close();
                    byte[] output = barray.toByteArray();
                    if (orphaned_low) {
                        throw new IOException();
                    }
                    Assert._assert(utf8 != null);
                    if (nullTerminate) {
                        Assert._assert(utf8.length - 1 == output.length);
                    } else {
                        Assert._assert(utf8.length == output.length);
                    }
                    int i = 0;
                    while (i < output.length) {
                        Assert._assert(utf8[i] == output[i]);
                        ++i;
                    }
                    throw throwable;
                }
                catch (UnsupportedEncodingException e) {
                    Assert.notReached("No UTF8 encoding conversion");
                    throw throwable;
                }
                catch (IOException e) {
                    Assert._assert(utf8 == null);
                    throw throwable;
                }
                catch (Exception e) {
                    Assert.notReached("UTF8Converter validation threw an unexpected exception");
                }
                throw throwable;
            }
            UTF8Converter.wipeBytes(utf8);
            utf8 = null;
        }
        ucs4 = 0;
        c = '\u0000';
        try {
            ByteArrayOutputStream barray = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)barray, "UTF8");
            writer.write(unicode, 0, unicode.length);
            writer.close();
            byte[] output = barray.toByteArray();
            if (orphaned_low) {
                throw new IOException();
            }
            Assert._assert(utf8 != null);
            if (nullTerminate) {
                Assert._assert(utf8.length - 1 == output.length);
            } else {
                Assert._assert(utf8.length == output.length);
            }
            int i = 0;
            while (i < output.length) {
                Assert._assert(utf8[i] == output[i]);
                ++i;
            }
            return byArray;
        }
        catch (UnsupportedEncodingException e) {
            Assert.notReached("No UTF8 encoding conversion");
            return byArray;
        }
        catch (IOException e) {
            Assert._assert(utf8 == null);
            return byArray;
        }
        catch (Exception e) {
            Assert.notReached("UTF8Converter validation threw an unexpected exception");
        }
        return byArray;
    }

    public static void wipeBytes(byte[] array) {
        Assert._assert(array != null);
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            array[i] = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Debug.setLevel(10);
        try {
            int i;
            System.out.println("ASCII Test:");
            char[] unicode = new char[128];
            for (i = 0; i < 128; ++i) {
                unicode[i] = (char)i;
            }
            byte[] utf8 = UTF8Converter.UnicodeToUTF8(unicode);
            i = 0;
            while (i < 128) {
                int j;
                for (j = i; j < 128 && j < i + 20; ++j) {
                    System.out.print(unicode[j] + " ");
                }
                System.out.println();
                for (j = i; j < 128 && j < i + 20; ++j) {
                    System.out.print(utf8[j] + " ");
                }
                System.out.println("\n");
                i = j;
            }
            System.out.println("UCS2 test:");
            unicode = new char[]{'\u0000', '\u007f', '\u0080', '\u0400', '\u07ff', '\u0800', '\u3167', '\ud7ff', '\ue000', '\uffff'};
            utf8 = UTF8Converter.UnicodeToUTF8(unicode);
            for (i = 0; i < 10; ++i) {
                System.out.print(Integer.toHexString(unicode[i]) + " ");
            }
            System.out.println();
            for (i = 0; i < utf8.length; ++i) {
                System.out.print(Integer.toHexString(utf8[i]) + " ");
            }
            System.out.println();
            System.out.println("Maximum buffer size test:");
            unicode = new char[]{'\uffff', '\uffff', '\uffff', '\uffff'};
            utf8 = UTF8Converter.UnicodeToUTF8(unicode);
            Assert._assert(utf8.length == 12);
            System.out.println("8 bytes of unicode --> " + utf8.length + " bytes of utf8\n");
            System.out.println("Empty input test:");
            unicode = new char[]{};
            utf8 = UTF8Converter.UnicodeToUTF8(unicode);
            Assert._assert(utf8 != null);
            Assert._assert(utf8.length == 0);
            System.out.println("given 0 bytes Unicode, produces 0 length utf8\n");
            System.out.println("UCS4 Test:");
            unicode = new char[]{'\ud800', '\udc00', '\uda85', '\ude47', '\udbff', '\udfff'};
            utf8 = UTF8Converter.UnicodeToUTF8(unicode);
            for (i = 0; i < 6; ++i) {
                System.out.print(Integer.toHexString(unicode[i]) + " ");
            }
            System.out.println();
            for (i = 0; i < utf8.length; ++i) {
                System.out.print(Integer.toHexString(utf8[i]) + " ");
            }
            System.out.println("\n");
            System.out.println("high half at end of input:");
            try {
                unicode = new char[]{'\ud800'};
                utf8 = UTF8Converter.UnicodeToUTF8(unicode);
                Assert.notReached("should have failed on bad UCS4");
            }
            catch (CharConversionException e) {
                System.out.println("Correctly caught bad UCS4\n");
            }
            System.out.println("high half with something other than low half:");
            try {
                unicode = new char[]{'\ud800', '\u007f'};
                utf8 = UTF8Converter.UnicodeToUTF8(unicode);
                Assert.notReached("should have failed on bad UCS4");
            }
            catch (CharConversionException e) {
                System.out.println("Correctly caught bad UCS4\n");
            }
            System.out.println("orphaned low half test:");
            try {
                unicode = new char[]{'2', '\udc01', '3'};
                utf8 = UTF8Converter.UnicodeToUTF8(unicode);
                Assert.notReached("should have failed on bad UCS4");
            }
            catch (CharConversionException e) {
                System.out.println("Correctly caught bad UCS4\n");
            }
            System.out.println("null-terminating:");
            unicode = new char[]{'f', 'o', 'o', 'b', 'a', 'r'};
            utf8 = UTF8Converter.UnicodeToUTF8NullTerm(unicode);
            for (i = 0; i < unicode.length; ++i) {
                System.out.print(unicode[i] + " ");
            }
            System.out.println();
            for (i = 0; i < utf8.length; ++i) {
                System.out.print(utf8[i] + " ");
            }
            System.out.println("\n");
        }
        catch (CharConversionException e) {
            System.out.println("Error converting Unicode " + e);
        }
    }
}

